///////////////////////////////////////////////////////////////////////////////////////////////
/// Viewer di file BMP per Arduino Rev4 + Adafruit TFT 1.8 Ver.2 Shield
///                   By Fischetti P.
///
/// NB!: i file devono essere esclusivamente Bitmap (cioe' con estensione .bmp) 
/// max 160x128 a 24 bit, e i nomi al massimo lunghi 13 caratteri (nomefile max 8 caratteri + .bmp)
///
/// Usare: Tasto C per andare avanti, tasto B per tornare inizio e tasto A per andare indietro
///////////////////////////////////////////////////////////////////////////////////////////////
#include <Adafruit_GFX.h>         // Core graphics library
#include <Adafruit_ST7735.h>      // Hardware-specific library
#include <Adafruit_seesaw.h>
#include <SdFat.h>                // SD card & FAT filesystem library

#include <Adafruit_SPIFlash.h>    // SPI / QSPI flash library
#include <Adafruit_ImageReader.h> // Image-reading functions
#include <Adafruit_TFTShield18.h>
Adafruit_TFTShield18 ss;

// TFT display and SD card share the hardware SPI interface, using
// 'select' pins for each to identify the active device on the bus.

#define SD_CS    4 // SD card select pin
#define TFT_CS  10 // TFT select pin
#define TFT_DC   8 // TFT display/command pin
#define TFT_RST  -1 // Or set to -1 and connect to Arduino RESET pin
#define BUFFPIXEL 20

SdFat                SD;         // SD card filesystem
Adafruit_ImageReader reader(SD); // Image-reader object, pass in SD filesys

Adafruit_ST7735      tft    = Adafruit_ST7735(TFT_CS, TFT_DC, TFT_RST);
Adafruit_Image       img;        // An image loaded into RAM
int32_t              width  = 0, // BMP image dimensions
                     height = 0;

uint16_t numOfFiles = 0;
int currFileIndex=-1;
char buff[13];///Buffer per contenere i nomi dei file MAX 12!!!!!!(8+4)
///NB: solo bitmap permette la TFT 1.8
#define sExt ".bmp"


int fileType(const char *name, const char *ext){
int sl=0;
sl=strlen(name)-strlen(ext);
if (sl>0){
    const char *p=&name[sl];
    if(strcasecmp((const char *)p, ext) == 0){
      return 1;
    }
    else
      return 0;
}
else
 return 0;
}

/// Ritorna il num. di file presenti su SD con quell'estensione
int getNumOfFiles(File dir){
  char buff[32];
  int nof=0;
  while (true) {

    File entry =  dir.openNextFile();
    if (! entry) {
      // no more files
      break;
    }

    if (entry.isFile()) {
      entry.getName(buff,sizeof(buff));
      if(1==fileType(buff,sExt))
        nof++;
    }
    entry.close();
  }
  return nof;
}
///Ritorna l'elenco di files presenti su SD
void printDirectory(File dir) {
  char buff[32];
  int nof=0;
  while (true) {

    File entry =  dir.openNextFile();
    if (! entry) {
      // no more files
      break;
    }

    entry.getName(buff,sizeof(buff));
    
    if (entry.isDirectory()) {

    } else {
      // files have sizes, directories do not
      if(1==fileType(buff,sExt)){
        Serial.print(nof, DEC);
        Serial.print("\t");
        Serial.print(buff);
      Serial.print("\t");
      Serial.println(entry.size(), DEC);
      nof++;
      }
    }
    entry.close();
  }
}

///Ritorna il file nella posizione di indice richiesto (per evitare di usare un array dei file in memoria)
int getFileNameByIndex (File dir, int i,char *name,int sz){
  int nof=0;
  while (true) {
	if(i<0 || i>numOfFiles-1)
	return -1;
		File entry =  dir.openNextFile();
		if (! entry) {
		  // no more files
		  break;
		}

		if (entry.isFile()) {
			if(!(nof <=numOfFiles && i <numOfFiles))
			  return NULL;
			
			  entry.getName(name,sz);
			  Serial.println(name);   
			  if(1==fileType(name,sExt)){
				if(nof==i){
				  return nof;
				}
				else
				  nof++;
			  }
			
		}
		entry.close();
  }
  return -1;

}

//setup di SD, calcolo bnum files con ext presenti, TFT e splash screen
void setup(void) {
  ImageReturnCode stat;

  Serial.begin(9600);
  #if !defined(ESP32)
    while (!Serial);      
  #endif

  // start by disabling both SD and TFT
  pinMode(TFT_CS, OUTPUT);
  digitalWrite(TFT_CS, HIGH);
  pinMode(SD_CS, OUTPUT);
  digitalWrite(SD_CS, HIGH);

  // Start seesaw helper chip
  if (!ss.begin()){
    Serial.println("seesaw could not be initialized!");
    while(1);
  }
  Serial.println("seesaw started");
  Serial.print("Version: "); Serial.println(ss.getVersion(), HEX);

  // Start set the backlight off
  ss.setBacklight(TFTSHIELD_BACKLIGHT_OFF);
  // Reset the TFT
  ss.tftReset();

  // Initialize 1.8" TFT
  tft.initR(INITR_BLACKTAB);   // initialize a ST7735S chip, black tab

  Serial.println("TFT OK!");
  tft.fillScreen(ST77XX_CYAN);

  // The Adafruit_ImageReader constructor call (above, before setup())
  // accepts an uninitialized SdFat or FatVolume object. This MUST
  // BE INITIALIZED before using any of the image reader functions!
  Serial.print(F("Initializing SD filesystem...\n"));
  if(!SD.begin(SD_CS, SD_SCK_MHZ(10))) { // Breakouts require 10 MHz limit due to longer wires
    Serial.println(F("SD begin() failed"));
    for(;;); // Fatal error, do not continue
  }

    File root = SD.open("/");
    printDirectory(root);
    Serial.print("NofFiles:");
    numOfFiles=getNumOfFiles(root);
    Serial.println(numOfFiles);
    root.close();

	  // Fill screen blue. Not a required step, this just shows that we're
	  // successfully communicating with the screen.
	  tft.fillScreen(ST7735_BLUE);

	  for (int32_t i=TFTSHIELD_BACKLIGHT_OFF; i<TFTSHIELD_BACKLIGHT_ON; i+=100) {
		ss.setBacklight(i);
		delay(1);
	  }
	  delay(100);
	  tft.fillScreen(ST77XX_RED);
	  delay(100);
	  tft.fillScreen(ST77XX_GREEN);
	  delay(100);
	  tft.fillScreen(ST77XX_BLUE);
	  delay(100);
	  tft.fillScreen(ST77XX_BLACK);
	 
	  tft.setTextSize(1);
	  tft.setTextColor(ST77XX_WHITE);
	  tft.setCursor(0, 0);
	  tft.print("OK");
    Serial.println(F("Setup OK"));
}

void loop() {
    uint32_t buttons = ss.readButtons();
    if(! (buttons & TFTSHIELD_BUTTON_1) && numOfFiles>0){
		///Prev
     if(numOfFiles>0){ 
        currFileIndex--;
      if(currFileIndex<0)
          currFileIndex=0;
        File root = SD.open("/");
        if(getFileNameByIndex(root,currFileIndex,buff,sizeof(buff))>=0){
          tft.fillScreen(ST77XX_BLACK);
          Serial.print("Draw:");
          Serial.println(buff);
          reader.drawBMP(buff,tft,0,0);
          }
        root.close();
    }
  }
  if(! (buttons & TFTSHIELD_BUTTON_2) && numOfFiles>0){
   if(numOfFiles>0){
    currFileIndex=0;
    File root = SD.open("/");
    if(getFileNameByIndex(root,currFileIndex,buff,sizeof(buff))>=0){
      tft.fillScreen(ST77XX_BLACK);
      Serial.print("Draw:");
      Serial.println(buff);
      reader.drawBMP(buff,tft,0,0);
      }
    root.close();
    }
  }
  if(! (buttons & TFTSHIELD_BUTTON_3) && numOfFiles>0){
     if(numOfFiles>0){ 
		  currFileIndex++;
		  if(currFileIndex>=numOfFiles)
		    currFileIndex=numOfFiles-1;
		  File root = SD.open("/");
      if(getFileNameByIndex(root,currFileIndex,buff,sizeof(buff))>=0){
        tft.fillScreen(ST77XX_BLACK);
        Serial.print("Draw:");
        Serial.println(buff);
        reader.drawBMP(buff,tft,0,0);
      }
		  root.close();
       }
  }
  delay(100); 
}