/*
 * Decompiled with CFR 0.152.
 */
package com.somsakelect.android.mqtt;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.somsakelect.android.mqtt.MessageStore;
import com.somsakelect.android.mqtt.MqttService;
import com.somsakelect.android.mqtt.MqttTraceHandler;
import java.util.Iterator;
import java.util.UUID;
import org.eclipse.paho.client.mqttv3.MqttMessage;

class DatabaseMessageStore
implements MessageStore {
    private static final String TAG = "DatabaseMessageStore";
    private static final String MTIMESTAMP = "mtimestamp";
    private static final String ARRIVED_MESSAGE_TABLE_NAME = "MqttArrivedMessageTable";
    private SQLiteDatabase db = null;
    private MQTTDatabaseHelper mqttDb = null;
    private MqttTraceHandler traceHandler = null;

    public DatabaseMessageStore(MqttService service, Context context) {
        this.traceHandler = service;
        this.mqttDb = new MQTTDatabaseHelper(this.traceHandler, context);
        this.traceHandler.traceDebug(TAG, "DatabaseMessageStore<init> complete");
    }

    @Override
    public String storeArrived(String clientHandle, String topic, MqttMessage message) {
        this.db = this.mqttDb.getWritableDatabase();
        this.traceHandler.traceDebug(TAG, "storeArrived{" + clientHandle + "}, {" + message.toString() + "}");
        byte[] payload = message.getPayload();
        int qos = message.getQos();
        boolean retained = message.isRetained();
        boolean duplicate = message.isDuplicate();
        ContentValues values = new ContentValues();
        String id = UUID.randomUUID().toString();
        values.put("messageId", id);
        values.put("clientHandle", clientHandle);
        values.put("destinationName", topic);
        values.put("payload", payload);
        values.put("qos", Integer.valueOf(qos));
        values.put("retained", Boolean.valueOf(retained));
        values.put("duplicate", Boolean.valueOf(duplicate));
        values.put(MTIMESTAMP, Long.valueOf(System.currentTimeMillis()));
        try {
            this.db.insertOrThrow(ARRIVED_MESSAGE_TABLE_NAME, null, values);
        }
        catch (SQLException e) {
            this.traceHandler.traceException(TAG, "onUpgrade", (Exception)((Object)e));
            throw e;
        }
        int count = this.getArrivedRowCount(clientHandle);
        this.traceHandler.traceDebug(TAG, "storeArrived: inserted message with id of {" + id + "} - Number of messages in database for this clientHandle = " + count);
        return id;
    }

    private int getArrivedRowCount(String clientHandle) {
        int count = 0;
        String[] projection = new String[]{"messageId"};
        String selection = "clientHandle=?";
        String[] selectionArgs = new String[]{clientHandle};
        Cursor c = this.db.query(ARRIVED_MESSAGE_TABLE_NAME, projection, selection, selectionArgs, null, null, null);
        if (c.moveToFirst()) {
            count = c.getInt(0);
        }
        c.close();
        return count;
    }

    @Override
    public boolean discardArrived(String clientHandle, String id) {
        int rows;
        this.db = this.mqttDb.getWritableDatabase();
        this.traceHandler.traceDebug(TAG, "discardArrived{" + clientHandle + "}, {" + id + "}");
        String[] selectionArgs = new String[]{id, clientHandle};
        try {
            rows = this.db.delete(ARRIVED_MESSAGE_TABLE_NAME, "messageId=? AND clientHandle=?", selectionArgs);
        }
        catch (SQLException e) {
            this.traceHandler.traceException(TAG, "discardArrived", (Exception)((Object)e));
            throw e;
        }
        if (rows != 1) {
            this.traceHandler.traceError(TAG, "discardArrived - Error deleting message {" + id + "} from database: Rows affected = " + rows);
            return false;
        }
        int count = this.getArrivedRowCount(clientHandle);
        this.traceHandler.traceDebug(TAG, "discardArrived - Message deleted successfully. - messages in db for this clientHandle " + count);
        return true;
    }

    @Override
    public Iterator<MessageStore.StoredMessage> getAllArrivedMessages(final String clientHandle) {
        return new Iterator<MessageStore.StoredMessage>(){
            private Cursor c;
            private boolean hasNext;
            private final String[] selectionArgs;
            {
                this.selectionArgs = new String[]{clientHandle};
                DatabaseMessageStore.this.db = DatabaseMessageStore.this.mqttDb.getWritableDatabase();
                this.c = clientHandle == null ? DatabaseMessageStore.this.db.query(DatabaseMessageStore.ARRIVED_MESSAGE_TABLE_NAME, null, null, null, null, null, "mtimestamp ASC") : DatabaseMessageStore.this.db.query(DatabaseMessageStore.ARRIVED_MESSAGE_TABLE_NAME, null, "clientHandle=?", this.selectionArgs, null, null, "mtimestamp ASC");
                this.hasNext = this.c.moveToFirst();
            }

            @Override
            public boolean hasNext() {
                if (!this.hasNext) {
                    this.c.close();
                }
                return this.hasNext;
            }

            @Override
            public MessageStore.StoredMessage next() {
                String messageId = this.c.getString(this.c.getColumnIndex("messageId"));
                String clientHandle2 = this.c.getString(this.c.getColumnIndex("clientHandle"));
                String topic = this.c.getString(this.c.getColumnIndex("destinationName"));
                byte[] payload = this.c.getBlob(this.c.getColumnIndex("payload"));
                int qos = this.c.getInt(this.c.getColumnIndex("qos"));
                boolean retained = Boolean.parseBoolean(this.c.getString(this.c.getColumnIndex("retained")));
                boolean dup = Boolean.parseBoolean(this.c.getString(this.c.getColumnIndex("duplicate")));
                MqttMessageHack message = new MqttMessageHack(payload);
                message.setQos(qos);
                message.setRetained(retained);
                message.setDuplicate(dup);
                this.hasNext = this.c.moveToNext();
                return new DbStoredData(messageId, clientHandle2, topic, message);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            protected void finalize() throws Throwable {
                this.c.close();
                super.finalize();
            }
        };
    }

    @Override
    public void clearArrivedMessages(String clientHandle) {
        this.db = this.mqttDb.getWritableDatabase();
        String[] selectionArgs = new String[]{clientHandle};
        int rows = 0;
        if (clientHandle == null) {
            this.traceHandler.traceDebug(TAG, "clearArrivedMessages: clearing the table");
            rows = this.db.delete(ARRIVED_MESSAGE_TABLE_NAME, null, null);
        } else {
            this.traceHandler.traceDebug(TAG, "clearArrivedMessages: clearing the table of " + clientHandle + " messages");
            rows = this.db.delete(ARRIVED_MESSAGE_TABLE_NAME, "clientHandle=?", selectionArgs);
        }
        this.traceHandler.traceDebug(TAG, "clearArrivedMessages: rows affected = " + rows);
    }

    @Override
    public void close() {
        if (this.db != null) {
            this.db.close();
        }
    }

    private class MqttMessageHack
    extends MqttMessage {
        public MqttMessageHack(byte[] payload) {
            super(payload);
        }

        protected void setDuplicate(boolean dup) {
            super.setDuplicate(dup);
        }
    }

    private class DbStoredData
    implements MessageStore.StoredMessage {
        private String messageId;
        private String clientHandle;
        private String topic;
        private MqttMessage message;

        DbStoredData(String messageId, String clientHandle, String topic, MqttMessage message) {
            this.messageId = messageId;
            this.topic = topic;
            this.message = message;
        }

        @Override
        public String getMessageId() {
            return this.messageId;
        }

        @Override
        public String getClientHandle() {
            return this.clientHandle;
        }

        @Override
        public String getTopic() {
            return this.topic;
        }

        @Override
        public MqttMessage getMessage() {
            return this.message;
        }
    }

    private static class MQTTDatabaseHelper
    extends SQLiteOpenHelper {
        private static final String TAG = "MQTTDatabaseHelper";
        private static final String DATABASE_NAME = "mqttAndroidService.db";
        private static final int DATABASE_VERSION = 1;
        private MqttTraceHandler traceHandler = null;

        public MQTTDatabaseHelper(MqttTraceHandler traceHandler, Context context) {
            super(context, DATABASE_NAME, null, 1);
            this.traceHandler = traceHandler;
        }

        public void onCreate(SQLiteDatabase database) {
            String createArrivedTableStatement = "CREATE TABLE MqttArrivedMessageTable(messageId TEXT PRIMARY KEY, clientHandle TEXT, destinationName TEXT, payload BLOB, qos INTEGER, retained TEXT, duplicate TEXT, mtimestamp INTEGER);";
            this.traceHandler.traceDebug(TAG, "onCreate {" + createArrivedTableStatement + "}");
            try {
                database.execSQL(createArrivedTableStatement);
                this.traceHandler.traceDebug(TAG, "created the table");
            }
            catch (SQLException e) {
                this.traceHandler.traceException(TAG, "onCreate", (Exception)((Object)e));
                throw e;
            }
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            this.traceHandler.traceDebug(TAG, "onUpgrade");
            try {
                db.execSQL("DROP TABLE IF EXISTS MqttArrivedMessageTable");
            }
            catch (SQLException e) {
                this.traceHandler.traceException(TAG, "onUpgrade", (Exception)((Object)e));
                throw e;
            }
            this.onCreate(db);
            this.traceHandler.traceDebug(TAG, "onUpgrade complete");
        }
    }
}

