/*
 * Decompiled with CFR 0.152.
 */
package com.somsakelect.android.mqtt;

import android.os.Bundle;
import android.os.Parcelable;
import android.os.PowerManager;
import android.util.Log;
import com.somsakelect.android.mqtt.AlarmPingSender;
import com.somsakelect.android.mqtt.MessageStore;
import com.somsakelect.android.mqtt.MqttService;
import com.somsakelect.android.mqtt.ParcelableMqttMessage;
import com.somsakelect.android.mqtt.Status;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;

class MqttConnection
implements MqttCallbackExtended {
    private static final String TAG = "MqttConnection";
    private static final String NOT_CONNECTED = "not connected";
    private String serverURI;
    private String clientId;
    private MqttClientPersistence persistence = null;
    private MqttConnectOptions connectOptions;
    private String clientHandle;
    private String reconnectActivityToken = null;
    private MqttAsyncClient myClient = null;
    private AlarmPingSender alarmPingSender = null;
    private MqttService service = null;
    private volatile boolean disconnected = true;
    private boolean cleanSession = true;
    private volatile boolean isConnecting = false;
    private Map<IMqttDeliveryToken, String> savedTopics = new HashMap<IMqttDeliveryToken, String>();
    private Map<IMqttDeliveryToken, MqttMessage> savedSentMessages = new HashMap<IMqttDeliveryToken, MqttMessage>();
    private Map<IMqttDeliveryToken, String> savedActivityTokens = new HashMap<IMqttDeliveryToken, String>();
    private Map<IMqttDeliveryToken, String> savedInvocationContexts = new HashMap<IMqttDeliveryToken, String>();
    private PowerManager.WakeLock wakelock = null;
    private String wakeLockTag = null;
    private DisconnectedBufferOptions bufferOpts = null;

    public String getServerURI() {
        return this.serverURI;
    }

    public void setServerURI(String serverURI) {
        this.serverURI = serverURI;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public MqttConnectOptions getConnectOptions() {
        return this.connectOptions;
    }

    public void setConnectOptions(MqttConnectOptions connectOptions) {
        this.connectOptions = connectOptions;
    }

    public String getClientHandle() {
        return this.clientHandle;
    }

    public void setClientHandle(String clientHandle) {
        this.clientHandle = clientHandle;
    }

    MqttConnection(MqttService service, String serverURI, String clientId, MqttClientPersistence persistence, String clientHandle) {
        this.serverURI = serverURI;
        this.service = service;
        this.clientId = clientId;
        this.persistence = persistence;
        this.clientHandle = clientHandle;
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getCanonicalName());
        stringBuilder.append(" ");
        stringBuilder.append(clientId);
        stringBuilder.append(" ");
        stringBuilder.append("on host ");
        stringBuilder.append(serverURI);
        this.wakeLockTag = stringBuilder.toString();
    }

    public void connect(MqttConnectOptions options, String invocationContext, String activityToken) {
        this.connectOptions = options;
        this.reconnectActivityToken = activityToken;
        if (options != null) {
            this.cleanSession = options.isCleanSession();
        }
        if (this.connectOptions.isCleanSession()) {
            this.service.messageStore.clearArrivedMessages(this.clientHandle);
        }
        this.service.traceDebug(TAG, "Connecting {" + this.serverURI + "} as {" + this.clientId + "}");
        final Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.activityToken", activityToken);
        resultBundle.putString("MqttService.invocationContext", invocationContext);
        resultBundle.putString("MqttService.callbackAction", "connect");
        try {
            if (this.persistence == null) {
                File myDir = this.service.getExternalFilesDir(TAG);
                if (myDir == null && (myDir = this.service.getDir(TAG, 0)) == null) {
                    resultBundle.putString("MqttService.errorMessage", "Error! No external and internal storage available");
                    resultBundle.putSerializable("MqttService.exception", (Serializable)new MqttPersistenceException());
                    this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
                    return;
                }
                this.persistence = new MqttDefaultFilePersistence(myDir.getAbsolutePath());
            }
            MqttConnectionListener listener = new MqttConnectionListener(resultBundle){

                @Override
                public void onSuccess(IMqttToken asyncActionToken) {
                    MqttConnection.this.doAfterConnectSuccess(resultBundle);
                    MqttConnection.this.service.traceDebug(MqttConnection.TAG, "connect success!");
                }

                @Override
                public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                    resultBundle.putString("MqttService.errorMessage", exception.getLocalizedMessage());
                    resultBundle.putSerializable("MqttService.exception", (Serializable)exception);
                    MqttConnection.this.service.traceError(MqttConnection.TAG, "connect fail, call connect to reconnect.reason:" + exception.getMessage());
                    MqttConnection.this.doAfterConnectFail(resultBundle);
                }
            };
            if (this.myClient != null) {
                if (this.isConnecting) {
                    this.service.traceDebug(TAG, "myClient != null and the client is connecting. Connect return directly.");
                    this.service.traceDebug(TAG, "Connect return:isConnecting:" + this.isConnecting + ".disconnected:" + this.disconnected);
                } else if (!this.disconnected) {
                    this.service.traceDebug(TAG, "myClient != null and the client is connected and notify!");
                    this.doAfterConnectSuccess(resultBundle);
                } else {
                    this.service.traceDebug(TAG, "myClient != null and the client is not connected");
                    this.service.traceDebug(TAG, "Do Real connect!");
                    this.setConnectingState(true);
                    this.myClient.connect(this.connectOptions, (Object)invocationContext, (IMqttActionListener)listener);
                }
            } else {
                this.alarmPingSender = new AlarmPingSender(this.service);
                this.myClient = new MqttAsyncClient(this.serverURI, this.clientId, this.persistence, (MqttPingSender)this.alarmPingSender);
                this.myClient.setCallback((MqttCallback)this);
                this.service.traceDebug(TAG, "Do Real connect!");
                this.setConnectingState(true);
                this.myClient.connect(this.connectOptions, (Object)invocationContext, (IMqttActionListener)listener);
            }
        }
        catch (Exception e) {
            this.service.traceError(TAG, "Exception occurred attempting to connect: " + e.getMessage());
            this.setConnectingState(false);
            this.handleException(resultBundle, e);
        }
    }

    private void doAfterConnectSuccess(Bundle resultBundle) {
        this.acquireWakeLock();
        this.service.callbackToActivity(this.clientHandle, Status.OK, resultBundle);
        this.deliverBacklog();
        this.setConnectingState(false);
        this.disconnected = false;
        this.releaseWakeLock();
    }

    public void connectComplete(boolean reconnect, String serverURI) {
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.callbackAction", "connectExtended");
        resultBundle.putBoolean("MqttService.reconnect", reconnect);
        resultBundle.putString("MqttService.serverURI", serverURI);
        this.service.callbackToActivity(this.clientHandle, Status.OK, resultBundle);
    }

    private void doAfterConnectFail(Bundle resultBundle) {
        this.acquireWakeLock();
        this.disconnected = true;
        this.setConnectingState(false);
        this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
        this.releaseWakeLock();
    }

    private void handleException(Bundle resultBundle, Exception e) {
        resultBundle.putString("MqttService.errorMessage", e.getLocalizedMessage());
        resultBundle.putSerializable("MqttService.exception", (Serializable)e);
        this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
    }

    private void deliverBacklog() {
        Iterator<MessageStore.StoredMessage> backlog = this.service.messageStore.getAllArrivedMessages(this.clientHandle);
        while (backlog.hasNext()) {
            MessageStore.StoredMessage msgArrived = backlog.next();
            Bundle resultBundle = this.messageToBundle(msgArrived.getMessageId(), msgArrived.getTopic(), msgArrived.getMessage());
            resultBundle.putString("MqttService.callbackAction", "messageArrived");
            this.service.callbackToActivity(this.clientHandle, Status.OK, resultBundle);
        }
    }

    private Bundle messageToBundle(String messageId, String topic, MqttMessage message) {
        Bundle result = new Bundle();
        result.putString("MqttService.messageId", messageId);
        result.putString("MqttService.destinationName", topic);
        result.putParcelable("MqttService.PARCEL", (Parcelable)new ParcelableMqttMessage(message));
        return result;
    }

    void close() {
        this.service.traceDebug(TAG, "close()");
        try {
            if (this.myClient != null) {
                this.myClient.close();
            }
        }
        catch (MqttException e) {
            this.handleException(new Bundle(), (Exception)((Object)e));
        }
    }

    void disconnect(long quiesceTimeout, String invocationContext, String activityToken) {
        this.service.traceDebug(TAG, "disconnect()");
        this.disconnected = true;
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.activityToken", activityToken);
        resultBundle.putString("MqttService.invocationContext", invocationContext);
        resultBundle.putString("MqttService.callbackAction", "disconnect");
        if (this.myClient != null && this.myClient.isConnected()) {
            MqttConnectionListener listener = new MqttConnectionListener(resultBundle);
            try {
                this.myClient.disconnect(quiesceTimeout, (Object)invocationContext, (IMqttActionListener)listener);
            }
            catch (Exception e) {
                this.handleException(resultBundle, e);
            }
        } else {
            resultBundle.putString("MqttService.errorMessage", NOT_CONNECTED);
            this.service.traceError("disconnect", NOT_CONNECTED);
            this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
        }
        if (this.connectOptions != null && this.connectOptions.isCleanSession()) {
            this.service.messageStore.clearArrivedMessages(this.clientHandle);
        }
        this.releaseWakeLock();
    }

    void disconnect(String invocationContext, String activityToken) {
        this.service.traceDebug(TAG, "disconnect()");
        this.disconnected = true;
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.activityToken", activityToken);
        resultBundle.putString("MqttService.invocationContext", invocationContext);
        resultBundle.putString("MqttService.callbackAction", "disconnect");
        if (this.myClient != null && this.myClient.isConnected()) {
            MqttConnectionListener listener = new MqttConnectionListener(resultBundle);
            try {
                this.myClient.disconnect((Object)invocationContext, (IMqttActionListener)listener);
            }
            catch (Exception e) {
                this.handleException(resultBundle, e);
            }
        } else {
            resultBundle.putString("MqttService.errorMessage", NOT_CONNECTED);
            this.service.traceError("disconnect", NOT_CONNECTED);
            this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
        }
        if (this.connectOptions != null && this.connectOptions.isCleanSession()) {
            this.service.messageStore.clearArrivedMessages(this.clientHandle);
        }
        this.releaseWakeLock();
    }

    public boolean isConnected() {
        return this.myClient != null && this.myClient.isConnected();
    }

    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained, String invocationContext, String activityToken) {
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.callbackAction", "send");
        resultBundle.putString("MqttService.activityToken", activityToken);
        resultBundle.putString("MqttService.invocationContext", invocationContext);
        IMqttDeliveryToken sendToken = null;
        if (this.myClient != null && this.myClient.isConnected()) {
            MqttConnectionListener listener = new MqttConnectionListener(resultBundle);
            try {
                MqttMessage message = new MqttMessage(payload);
                message.setQos(qos);
                message.setRetained(retained);
                sendToken = this.myClient.publish(topic, payload, qos, retained, (Object)invocationContext, (IMqttActionListener)listener);
                this.storeSendDetails(topic, message, sendToken, invocationContext, activityToken);
            }
            catch (Exception e) {
                this.handleException(resultBundle, e);
            }
        } else {
            resultBundle.putString("MqttService.errorMessage", NOT_CONNECTED);
            this.service.traceError("send", NOT_CONNECTED);
            this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
        }
        return sendToken;
    }

    public IMqttDeliveryToken publish(String topic, MqttMessage message, String invocationContext, String activityToken) {
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.callbackAction", "send");
        resultBundle.putString("MqttService.activityToken", activityToken);
        resultBundle.putString("MqttService.invocationContext", invocationContext);
        IMqttDeliveryToken sendToken = null;
        if (this.myClient != null && this.myClient.isConnected()) {
            MqttConnectionListener listener = new MqttConnectionListener(resultBundle);
            try {
                sendToken = this.myClient.publish(topic, message, (Object)invocationContext, (IMqttActionListener)listener);
                this.storeSendDetails(topic, message, sendToken, invocationContext, activityToken);
            }
            catch (Exception e) {
                this.handleException(resultBundle, e);
            }
        } else if (this.myClient != null && this.bufferOpts != null && this.bufferOpts.isBufferEnabled()) {
            MqttConnectionListener listener = new MqttConnectionListener(resultBundle);
            try {
                sendToken = this.myClient.publish(topic, message, (Object)invocationContext, (IMqttActionListener)listener);
                this.storeSendDetails(topic, message, sendToken, invocationContext, activityToken);
            }
            catch (Exception e) {
                this.handleException(resultBundle, e);
            }
        } else {
            Log.i((String)TAG, (String)"Client is not connected, so not sending message");
            resultBundle.putString("MqttService.errorMessage", NOT_CONNECTED);
            this.service.traceError("send", NOT_CONNECTED);
            this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
        }
        return sendToken;
    }

    public void subscribe(String topic, int qos, String invocationContext, String activityToken) {
        this.service.traceDebug(TAG, "subscribe({" + topic + "}," + qos + ",{" + invocationContext + "}, {" + activityToken + "}");
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.callbackAction", "subscribe");
        resultBundle.putString("MqttService.activityToken", activityToken);
        resultBundle.putString("MqttService.invocationContext", invocationContext);
        if (this.myClient != null && this.myClient.isConnected()) {
            MqttConnectionListener listener = new MqttConnectionListener(resultBundle);
            try {
                this.myClient.subscribe(topic, qos, (Object)invocationContext, (IMqttActionListener)listener);
            }
            catch (Exception e) {
                this.handleException(resultBundle, e);
            }
        } else {
            resultBundle.putString("MqttService.errorMessage", NOT_CONNECTED);
            this.service.traceError("subscribe", NOT_CONNECTED);
            this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
        }
    }

    public void subscribe(String[] topic, int[] qos, String invocationContext, String activityToken) {
        this.service.traceDebug(TAG, "subscribe({" + Arrays.toString(topic) + "}," + Arrays.toString(qos) + ",{" + invocationContext + "}, {" + activityToken + "}");
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.callbackAction", "subscribe");
        resultBundle.putString("MqttService.activityToken", activityToken);
        resultBundle.putString("MqttService.invocationContext", invocationContext);
        if (this.myClient != null && this.myClient.isConnected()) {
            MqttConnectionListener listener = new MqttConnectionListener(resultBundle);
            try {
                this.myClient.subscribe(topic, qos, (Object)invocationContext, (IMqttActionListener)listener);
            }
            catch (Exception e) {
                this.handleException(resultBundle, e);
            }
        } else {
            resultBundle.putString("MqttService.errorMessage", NOT_CONNECTED);
            this.service.traceError("subscribe", NOT_CONNECTED);
            this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
        }
    }

    public void subscribe(String[] topicFilters, int[] qos, String invocationContext, String activityToken, IMqttMessageListener[] messageListeners) {
        this.service.traceDebug(TAG, "subscribe({" + Arrays.toString(topicFilters) + "}," + Arrays.toString(qos) + ",{" + invocationContext + "}, {" + activityToken + "}");
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.callbackAction", "subscribe");
        resultBundle.putString("MqttService.activityToken", activityToken);
        resultBundle.putString("MqttService.invocationContext", invocationContext);
        if (this.myClient != null && this.myClient.isConnected()) {
            MqttConnectionListener listener = new MqttConnectionListener(resultBundle);
            try {
                this.myClient.subscribe(topicFilters, qos, messageListeners);
            }
            catch (Exception e) {
                this.handleException(resultBundle, e);
            }
        } else {
            resultBundle.putString("MqttService.errorMessage", NOT_CONNECTED);
            this.service.traceError("subscribe", NOT_CONNECTED);
            this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
        }
    }

    void unsubscribe(String topic, String invocationContext, String activityToken) {
        this.service.traceDebug(TAG, "unsubscribe({" + topic + "},{" + invocationContext + "}, {" + activityToken + "})");
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.callbackAction", "unsubscribe");
        resultBundle.putString("MqttService.activityToken", activityToken);
        resultBundle.putString("MqttService.invocationContext", invocationContext);
        if (this.myClient != null && this.myClient.isConnected()) {
            MqttConnectionListener listener = new MqttConnectionListener(resultBundle);
            try {
                this.myClient.unsubscribe(topic, (Object)invocationContext, (IMqttActionListener)listener);
            }
            catch (Exception e) {
                this.handleException(resultBundle, e);
            }
        } else {
            resultBundle.putString("MqttService.errorMessage", NOT_CONNECTED);
            this.service.traceError("subscribe", NOT_CONNECTED);
            this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
        }
    }

    void unsubscribe(String[] topic, String invocationContext, String activityToken) {
        this.service.traceDebug(TAG, "unsubscribe({" + Arrays.toString(topic) + "},{" + invocationContext + "}, {" + activityToken + "})");
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.callbackAction", "unsubscribe");
        resultBundle.putString("MqttService.activityToken", activityToken);
        resultBundle.putString("MqttService.invocationContext", invocationContext);
        if (this.myClient != null && this.myClient.isConnected()) {
            MqttConnectionListener listener = new MqttConnectionListener(resultBundle);
            try {
                this.myClient.unsubscribe(topic, (Object)invocationContext, (IMqttActionListener)listener);
            }
            catch (Exception e) {
                this.handleException(resultBundle, e);
            }
        } else {
            resultBundle.putString("MqttService.errorMessage", NOT_CONNECTED);
            this.service.traceError("subscribe", NOT_CONNECTED);
            this.service.callbackToActivity(this.clientHandle, Status.ERROR, resultBundle);
        }
    }

    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.myClient.getPendingDeliveryTokens();
    }

    public void connectionLost(Throwable why) {
        this.service.traceDebug(TAG, "connectionLost(" + why.getMessage() + ")");
        this.disconnected = true;
        try {
            if (!this.connectOptions.isAutomaticReconnect()) {
                this.myClient.disconnect(null, new IMqttActionListener(){

                    public void onSuccess(IMqttToken asyncActionToken) {
                    }

                    public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                    }
                });
            } else {
                this.alarmPingSender.schedule(100L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.callbackAction", "onConnectionLost");
        if (why != null) {
            resultBundle.putString("MqttService.errorMessage", why.getMessage());
            if (why instanceof MqttException) {
                resultBundle.putSerializable("MqttService.exception", (Serializable)why);
            }
            resultBundle.putString("MqttService.exceptionStack", Log.getStackTraceString((Throwable)why));
        }
        this.service.callbackToActivity(this.clientHandle, Status.OK, resultBundle);
        this.releaseWakeLock();
    }

    public void deliveryComplete(IMqttDeliveryToken messageToken) {
        this.service.traceDebug(TAG, "deliveryComplete(" + messageToken + ")");
        MqttMessage message = this.savedSentMessages.remove(messageToken);
        if (message != null) {
            String topic = this.savedTopics.remove(messageToken);
            String activityToken = this.savedActivityTokens.remove(messageToken);
            String invocationContext = this.savedInvocationContexts.remove(messageToken);
            Bundle resultBundle = this.messageToBundle(null, topic, message);
            if (activityToken != null) {
                resultBundle.putString("MqttService.callbackAction", "send");
                resultBundle.putString("MqttService.activityToken", activityToken);
                resultBundle.putString("MqttService.invocationContext", invocationContext);
                this.service.callbackToActivity(this.clientHandle, Status.OK, resultBundle);
            }
            resultBundle.putString("MqttService.callbackAction", "messageDelivered");
            this.service.callbackToActivity(this.clientHandle, Status.OK, resultBundle);
        }
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        this.service.traceDebug(TAG, "messageArrived(" + topic + ",{" + message.toString() + "})");
        String messageId = this.service.messageStore.storeArrived(this.clientHandle, topic, message);
        Bundle resultBundle = this.messageToBundle(messageId, topic, message);
        resultBundle.putString("MqttService.callbackAction", "messageArrived");
        resultBundle.putString("MqttService.messageId", messageId);
        this.service.callbackToActivity(this.clientHandle, Status.OK, resultBundle);
    }

    private void storeSendDetails(String topic, MqttMessage msg, IMqttDeliveryToken messageToken, String invocationContext, String activityToken) {
        this.savedTopics.put(messageToken, topic);
        this.savedSentMessages.put(messageToken, msg);
        this.savedActivityTokens.put(messageToken, activityToken);
        this.savedInvocationContexts.put(messageToken, invocationContext);
    }

    private void acquireWakeLock() {
        if (this.wakelock == null) {
            PowerManager pm = (PowerManager)this.service.getSystemService("power");
            this.wakelock = pm.newWakeLock(1, this.wakeLockTag);
        }
        this.wakelock.acquire();
    }

    private void releaseWakeLock() {
        if (this.wakelock != null && this.wakelock.isHeld()) {
            this.wakelock.release();
        }
    }

    void offline() {
        if (!this.disconnected && !this.cleanSession) {
            Exception e = new Exception("Android offline");
            this.connectionLost(e);
        }
    }

    synchronized void reconnect() {
        if (this.myClient == null) {
            this.service.traceError(TAG, "Reconnect myClient = null. Will not do reconnect");
            return;
        }
        if (this.isConnecting) {
            this.service.traceDebug(TAG, "The client is connecting. Reconnect return directly.");
            return;
        }
        if (!this.service.isOnline()) {
            this.service.traceDebug(TAG, "The network is not reachable. Will not do reconnect");
            return;
        }
        if (this.connectOptions.isAutomaticReconnect()) {
            Log.i((String)TAG, (String)"Requesting Automatic reconnect using New Java AC");
            Bundle resultBundle = new Bundle();
            resultBundle.putString("MqttService.activityToken", this.reconnectActivityToken);
            resultBundle.putString("MqttService.invocationContext", null);
            resultBundle.putString("MqttService.callbackAction", "connect");
            try {
                this.myClient.reconnect();
            }
            catch (MqttException ex) {
                Log.e((String)TAG, (String)("Exception occurred attempting to reconnect: " + ex.getMessage()));
                this.setConnectingState(false);
                this.handleException(resultBundle, (Exception)((Object)ex));
            }
        } else if (this.disconnected && !this.cleanSession) {
            this.service.traceDebug(TAG, "Do Real Reconnect!");
            final Bundle resultBundle = new Bundle();
            resultBundle.putString("MqttService.activityToken", this.reconnectActivityToken);
            resultBundle.putString("MqttService.invocationContext", null);
            resultBundle.putString("MqttService.callbackAction", "connect");
            try {
                MqttConnectionListener listener = new MqttConnectionListener(resultBundle){

                    @Override
                    public void onSuccess(IMqttToken asyncActionToken) {
                        MqttConnection.this.service.traceDebug(MqttConnection.TAG, "Reconnect Success!");
                        MqttConnection.this.service.traceDebug(MqttConnection.TAG, "DeliverBacklog when reconnect.");
                        MqttConnection.this.doAfterConnectSuccess(resultBundle);
                    }

                    @Override
                    public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                        resultBundle.putString("MqttService.errorMessage", exception.getLocalizedMessage());
                        resultBundle.putSerializable("MqttService.exception", (Serializable)exception);
                        MqttConnection.this.service.callbackToActivity(MqttConnection.this.clientHandle, Status.ERROR, resultBundle);
                        MqttConnection.this.doAfterConnectFail(resultBundle);
                    }
                };
                this.myClient.connect(this.connectOptions, null, (IMqttActionListener)listener);
                this.setConnectingState(true);
            }
            catch (MqttException e) {
                this.service.traceError(TAG, "Cannot reconnect to remote server." + e.getMessage());
                this.setConnectingState(false);
                this.handleException(resultBundle, (Exception)((Object)e));
            }
            catch (Exception e) {
                this.service.traceError(TAG, "Cannot reconnect to remote server." + e.getMessage());
                this.setConnectingState(false);
                MqttException newEx = new MqttException(6, e.getCause());
                this.handleException(resultBundle, (Exception)((Object)newEx));
            }
        }
    }

    private synchronized void setConnectingState(boolean isConnecting) {
        this.isConnecting = isConnecting;
    }

    public void setBufferOpts(DisconnectedBufferOptions bufferOpts) {
        this.bufferOpts = bufferOpts;
        this.myClient.setBufferOpts(bufferOpts);
    }

    public int getBufferedMessageCount() {
        return this.myClient.getBufferedMessageCount();
    }

    public MqttMessage getBufferedMessage(int bufferIndex) {
        return this.myClient.getBufferedMessage(bufferIndex);
    }

    public void deleteBufferedMessage(int bufferIndex) {
        this.myClient.deleteBufferedMessage(bufferIndex);
    }

    private class MqttConnectionListener
    implements IMqttActionListener {
        private final Bundle resultBundle;

        private MqttConnectionListener(Bundle resultBundle) {
            this.resultBundle = resultBundle;
        }

        public void onSuccess(IMqttToken asyncActionToken) {
            MqttConnection.this.service.callbackToActivity(MqttConnection.this.clientHandle, Status.OK, this.resultBundle);
        }

        public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
            this.resultBundle.putString("MqttService.errorMessage", exception.getLocalizedMessage());
            this.resultBundle.putSerializable("MqttService.exception", (Serializable)exception);
            MqttConnection.this.service.callbackToActivity(MqttConnection.this.clientHandle, Status.ERROR, this.resultBundle);
        }
    }
}

