#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if_arp.h>
#include <sys/types.h>
#include <net/if.h>
#include <netinet/in.h>
#include <linux/sockios.h>
#include <arpa/inet.h>

#include "utils.h"

char *getRemoteMAC(char *ip, char *ifname, char chMAC[MAC_LEN]){
int                 sd;
struct arpreq       areq;
struct sockaddr_in *sin;
struct in_addr      ipaddr;
	/* Get an internet domain socket. 
	*/
	if ((sd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) 
        return NULL;
	
	
	/* Make the ARP request. 
	*/
	memset(&areq, 0, sizeof(areq));
	sin = (struct sockaddr_in *) &areq.arp_pa;
	sin->sin_family = AF_INET;

	if (inet_aton(ip, &ipaddr) == 0)
        return NULL;	
	sin->sin_addr = ipaddr;
	sin = (struct sockaddr_in *) &areq.arp_ha;
	sin->sin_family = ARPHRD_ETHER;
	
	strncpy(areq.arp_dev, ifname, 15);
	
	if (ioctl(sd, SIOCGARP, (caddr_t) &areq) == -1) 
		return NULL;
	close(sd);

			inet_ntoa(((struct sockaddr_in *) &areq.arp_pa)->sin_addr);

			ethernet_mactoa(((struct sockaddr *)&areq.arp_ha)->sa_data,chMAC);
return chMAC;
}

