#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if_arp.h>
#include <sys/types.h>
#include <net/if.h>
#include <netinet/in.h>
#include <linux/sockios.h>
#include <arpa/inet.h>

#include "getLocalIP.h"
#include "getLocalMAC.h"
#include "getRemoteMAC.h"
#include "utils.h"

#include <pcap.h>

void die(char *s){
fprintf(stderr,"%s\n",s);
exit(-1);
}
int IsLocalIP(char *ip){
struct in_addr      ipaddr;
	if (inet_aton(ip, &ipaddr) == 0) {
		fprintf(stderr, "-- Error: bad IP Address '%s'.\n",ip);
		return -1;
	}

if(0==strcasecmp(ip,"localhost")|| 0==strcmp(ip,"127.0.0.1"))
    return 1;
unsigned char ip_address[15];
if(0==strcmp(ip,getLocalIP(ip_address)))
    return 1;
return 0;
}

//char *ethernet_mactoa(struct sockaddr *addr,unsigned char *buffMac) { 
 

	/*if (inet_aton(ip, &ipaddr) == 0) {
		fprintf(stderr, "-- Error: bad dotted-decimal IP '%s'.\n",
				ip);
		exit(1);
	}*/
int tokMAC(const char pmac[],u_char macs[6]){
char *ch=0;
int i=0;
int d;
char mac[MAC_LEN];
//char mac[]="00:15:5D:8B:6E:03";
strcpy(mac,pmac);

ch = strtok(mac, ":");

while(ch != NULL){
//printf("[%d]",atoi(ch));
sscanf(ch,"%x",&d);
macs[i++]=d;
ch=strtok(NULL,":");
}

return 0;
}
int SendPacket(char *ifName, char *localMAC,char *remoteMAC,char body[88])
{
char *dev; 
char errbuf[PCAP_ERRBUF_SIZE];
pcap_t *fp; 
void *contents = NULL; 
int i = 0;
u_char pkt[6]; 
/*if (getuid())
{
printf("Error! Must be root ... exiting\n");
return (1);
}*/
 
dev = pcap_lookupdev(errbuf);
 
if (dev == NULL)
{
fprintf(stderr, "Couldn't find default device: %s\n", errbuf);
return(2);
}

 
fp = pcap_open_live(dev, BUFSIZ, 1, 0, errbuf);
 
if (fp == NULL)
{
printf("pcap_open_live(): %s\n", errbuf);
return (1);
}

for(i=12;i<100;i++)
	pkt[i]=(u_char)body[i];
//MAC FROM
//pkt[0]=0x00;pkt[1]=0x15;pkt[2]=0x5d;pkt[3]=0x8b;pkt[4]=0x6e;pkt[5]=0x03;
//MAC TO
//pkt[6]=0x00;pkt[7]=0x15;pkt[8]=0x5d;pkt[9]=0x8b;pkt[10]=0x6e;pkt[11]=0x03;
tokMAC(localMAC,pkt);
tokMAC(remoteMAC,pkt+6);
//for(i=0;i<12;i++)
//    printf("%02X ",pkt[i]);
if(pcap_sendpacket(fp,pkt,100)!=0)
{
fprintf(stderr,"\nError di spedizione: %s\n",pcap_geterr(fp));
return 4;
}
}

void help(char *s){
printf("*** Send Packet ***\nUsage:%s [-dNIC] [IP Address]\nwhere:\n\tNIC: interface name (eth0)\n\tIP Address (127.0.0.1)\n",s);
}
int main(int argc, char **argv){
char localMAC[MAC_LEN],remoteMAC[MAC_LEN];
u_char  macs[6]; 
char *ifname;
char *pch=NULL;
char body[88];
    ifname="eth0"; /* Ethernet */
    ////ifname="wlan0"; /* Wifi */

//getMACAddress(argv[1],ifname,mac);
//printf("%s\n",mac);
char *ip="127.0.0.1";
for (int i=1; i < argc; i++){
    if(('-'==argv[i][0])|| ('-'==argv[i][0])){
        char cp=argv[i][1];
        switch(cp){
            case 'd':{
                ifname=&argv[i][2];
            }
            break;
            case '?':
            case 'h':
            default:{
                help(argv[0]);return 1;
            }
        }
    }
    else{
        ip=argv[i];//help(argv[0]);return 1;
    }
}
printf("%s %s\n",ifname,ip);
int lr=0;
lr = IsLocalIP(ip);
if(-1==lr)
    die("");

pch=getLocalMAC("127.0.0.1",ifname,localMAC);
if(NULL==pch)
    die(strerror(errno));
if(0==lr){
pch=getRemoteMAC(ip,ifname,remoteMAC);

if(NULL==pch)
    die(strerror(errno));

}
else
    strcpy(remoteMAC,localMAC);

printf("%s -> %s\n",localMAC,remoteMAC);
tokMAC(localMAC,macs);
for (int i=0; i < 6;i++)//sizeof(macs); i++)
    printf("%02X ",macs[i]);
tokMAC(remoteMAC,macs);
printf("\n");
for (int i=0; i < 6;i++)//sizeof(macs); i++)
    printf("%02X ",macs[i]);

char *p=fgets(body, sizeof(body), stdin);
if(!p)
    die("error on fgets\n");
size_t n=strlen(body);
if(n>0 && body[n-1]){
    body[n-1]='\0';
}
else
    fprintf(stderr,"fgets:Buffer too short or EOF reached without newline\n");
SendPacket(ifname,localMAC,remoteMAC,body);
printf("\n");
return 0;
}



