#include <conio.h>
#include <stdio.h>
#include <winsock2.h>
#include <windows.h>

#include "iphlpapi.h"
#define HAVE_REMOTE 1
#include "pcap.h"


#define NUMNIC 16  // quante schede NIC
#define DIMNIC 80 // n. caratteri per nome

int main(void)
{
  IP_ADAPTER_INFO AdapterInfo[16]; // per 16 MAC address
  IP_ADAPTER_INFO* pAdapterInfo; // per maneggiare il buffer
  DWORD dw;
  char *aszNome[NUMNIC]; // un elemento per Scheda
  int i,j;
  char ch;
	char errbuf[PCAP_ERRBUF_SIZE+1];
	pcap_t *fp;
	unsigned char pkt[100];

  dw = sizeof(AdapterInfo);
  if (GetAdaptersInfo(AdapterInfo,&dw)!=NO_ERROR) return 1;

  j=0;
  pAdapterInfo = AdapterInfo;
  while(pAdapterInfo)	// se c' un elemento
  {
    //if (pAdapterInfo->Type==MIB_IF_TYPE_ETHERNET)
    {
      aszNome[j] = (char *)malloc(DIMNIC);
      sprintf(aszNome[j],"\\Device\\NPF_%s",pAdapterInfo->AdapterName);
      printf("\nNIC %d: %s\nNome: %s\n",j+1, pAdapterInfo->Description, aszNome[j]);
      j++;
    }
    pAdapterInfo = pAdapterInfo->Next; // il prossimo...
  }

  printf("\nScegliere una interfaccia: ");
  ch = getche();
  if ((ch -'0')>j) return 2;
  j = ch-'0'-1;
//printf("%s",aszNome[j]);
	if ((fp = pcap_open_live(aszNome[j],		// apertura dell'interfaccia di rete
							 65536,	// dimensione del pacchetto da catturare (non serve)
							 1,			// impostazione del modo promniscuo
							 1000,	// timeout di lettura (non serve)
							 errbuf	// error buffer
							 )) == NULL)
	{
		fprintf(stderr,"\nImpossibile aprire l'interfaccia %s %s\n", aszNome[j],errbuf); return 3;
	}

  // Indirizzo MAC destinazione
//3C-A0-67-8F-E2-59
  // Indirizzo MAC destinazione
  pkt[0] = 0x3C; pkt[1] = 0xA0; pkt[2] = 0x67; pkt[3] = 0x8F; pkt[4] = 0xE2; pkt[5] = 0x59;
  // Indirizzo MAC mittente
  pkt[6] = 0x3C; pkt[7] = 0xA0; pkt[8] = 0x67; pkt[9] = 0x8F; pkt[10] = 0xE2; pkt[11] = 0x59;

	// pacchetto da 100 byte, praticamente casuale...
	for(i=12; i<100; i++)
	{
		pkt[i]= (unsigned char)i;
	}
printf("Sending...\n");
	// Spedizione del pacchetto sull'interfaccia specificata
	if (pcap_sendpacket(fp, pkt, 100) != 0)
	{
		fprintf(stderr,"\nErrore di spedizione: %s\n", pcap_geterr(fp)); return 4;
	}

printf("Sent!\n");
	pcap_close(fp);
	return 0;
}

