#pragma once
#ifndef ValleyGrid3d_h
#define ValleyGrid3d_h
#include <windows.h>
#include "M3Ops.h"
#include <string>
using namespace std;

/*
struct Point3D
{
    float coord[4];
    float trans[4];
};
*/
struct Point3D;
class ValleyGrid3d
{
private:
	float Xmin;// Min X and Y values.
	float Zmin;
	float Dx;//        ' Spacing between rows of data.
	float Dz;
	int NumX;//     ' Number of X and Y entries.
	int NumZ;
	Point3D** points;// ' Data values.

public:
	bool RemoveHidden;
	void SetBounds(float x1, float deltax, int xnum, float z1, float deltaz, int znum);
	void GenerateSurface(int divisions,float Dy);
	void Flatten(float target_y, float range, float smooth_factor);
	HBRUSH FillColor(HDC hdc,string sItem="", COLORREF *cr = NULL);

	HBRUSH PickColor(HDC hdc, float y1, float y2, float y3, float y4);
	void Subdivide(int i1, int i2, int j1, int j2, float Dy);
	void SetValue(float X, float Y, float Z);
	void ApplyFull(float M[4][4]);
	void Apply(float M[4][4]);
	void Draw(HDC hdc);
};
#endif

