#pragma once
#ifndef VALLEY_H
#define VALLEY_H
#include "ValleyGrid3d.h"
#include "IFractal.h"
#define _USE_MATH_DEFINES
#include <math.h>
typedef struct ValleyParams
{
	int levels = 4;
	float dyvs = 0.25;
}ValleyParams;
class clsValley: public IFractal{

public:
	ValleyParams valleyParams;
//// Location of viewing eye.
	float EyeR=0;
	float EyeTheta=0;
	float EyePhi=0;
	
	const float Dr = 1;
	const float Dtheta = M_PI / 20.;
	const float Dphi = M_PI / 20.;
private:	
	float divisorPolygon=1.;
	int numLevels = valleyParams.levels;
	float jaggedFactor = valleyParams.dyvs;


	//' Location of focus point.
	const float FocusX = 0;
	const float FocusY = 0;
	const float FocusZ = 0;
	//
	float Projector[4][4];

	ValleyGrid3d* TheGrid; 

	const float Xmin = -5;
	const float Zmin = -5;
	//' Return the Y coordinate for these X and
	//' Z coordinates.
	float YValue(float X, float Z)
	{
	float Y=0;

		Y = -2 * cos(2 * M_PI / 10 * Z) * (5 - abs(Z)) / 5 + 0.25 * sin(2 * X) + 0.25 * sin(1. * X) + 0.5 * myrand();
		if (Y < -1)
			Y = -1;

		return Y;
	}

	// Create the surface.
	void CreateData()
	{
		numLevels = valleyParams.levels;
		jaggedFactor = valleyParams.dyvs;
		
		const float Dx = 1./divisorPolygon;
		const float Dz = 1./divisorPolygon;
		const int NumX = -2 * Xmin / Dx;
		const int NumZ = -2 * Zmin / Dz;

		int i=0;
		int j=0;
		float X=0;
		float Y=0;
		float Z=0;
		int level=0;
		float Dy=0;
		float small_dx=0;
		float small_dz=0;
		float min_z=0;
		float max_z=0;
		float river_width=0;
		float period1=0;
		float period2=0;
		float period3=0;

		 TheGrid = new ValleyGrid3d();
		TheGrid->SetBounds( Xmin, Dx, NumX, Zmin, Dz, NumZ);

		X = Xmin;
		for( i = 0; i < NumX; i++)
		{
			Z = Zmin;
			for( j = 0; j < NumZ; j++)
			{
				Y = YValue(X, Z);
				TheGrid->SetValue( X, Y, Z);
				Z += Dz;
			}
			X += Dx;
		}

		level = numLevels;


		Dy = jaggedFactor; 
	  
		TheGrid->GenerateSurface (level, Dy);

		// Flatten the bottom.
		TheGrid->Flatten( -1, Dy,Dy);

		// Make a river bed in the bottom.
		period1 = 0.5 + myrand() * 1;
		period2 = 0.5 + myrand() * 1;
		period3 = 0.5 + myrand() * 1;
		small_dx = Dx / (pow(2, level));
		small_dz = Dz / (pow(2, level));
		X = Xmin;
		for (i = 0; i < NumX * (pow(2, level)) - (pow(2, level) - 1);i++)
		{
			river_width = abs(sin(X / 3) * myrand() / 2 + sin(X / 2.5) * myrand() / 3 - sin(X) * myrand() / 4) + 1 / 8;
			if (river_width < 2 * small_dx)
				 river_width = 2 * small_dx;
			min_z = sin(X / period1) / 2 + sin(X / period2) / 4 - sin(X / period3) / 8;
			max_z = min_z + river_width;
			for (Z = min_z; Z < max_z; Z+= small_dz)
			{
				TheGrid->SetValue (X, -1.1, Z);
			}
			X +=  small_dx;
		}
	}

	void picCls(HDC hdc)
	{
		HWND hWnd = WindowFromDC(hdc);
		RECT rc;
		GetClientRect(hWnd,&rc);
		Rectangle(hdc,rc.left,rc.top,rc.right,rc.bottom);   
	}
	
	public:
	clsValley();
	void draw (HWND hWnd,HDC hdc);
	char* toString ();

};

#endif
