// Trees.cpp : definisce il punto di ingresso dell'applicazione.
//

#include "Trees.h"
#include "stdafx.h"
#include <math.h>
#include <time.h>
#include <stdio.h>
#include "IFractal.h"
#include "myRand.h"

#include "Valley.h"

#define MAX_LOADSTRING 100
void DrawBranch(HDC hdc, float thickness, int depth, float X, float Y, float length, float length_scale,float theta,float dtheta);
void DrawBranch2(HDC hdc, int depth, float X,float Y, float length,float theta, float dtheta,float length_Scale);
void DrawBranch3(HDC hdc, float bend, float thickness,int Depth,float X, float Y,float length,float length_scale,float rnd_scale,float theta, float dtheta,float rnd_dtheta,int max_branches);
void LineStep(HDC hdc,int dx, int dy);
void calcHilbert(HDC hdc, int depth ,float dx,float dy);
void DrawFlakeEdge(HDC hdc,int depth, float &x1, float &y1, float theta,float dist,float offset);
void DrawFlake(HDC hdc,int depth, float length,float offset);
void MakeMovie(HDC hdc, int depth,float length);
void InitializeGenerator(HDC hdc, float theta, float length);

// Variabili globali:
HINSTANCE hInst;								// istanza corrente
TCHAR szTitle[MAX_LOADSTRING];					// Testo della barra del titolo
TCHAR szWindowClass[MAX_LOADSTRING];			// nome della classe di finestre principale

// Dichiarazioni con prototipo delle funzioni incluse in questo modulo di codice:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

int iDelay = 0;
HINSTANCE hInstance;
#define BUFF_SIZE 100
char buff[BUFF_SIZE];
int APIENTRY _tWinMain(HINSTANCE hInst,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
 	// TODO: inserire qui il codice.
	MSG msg;
	HACCEL hAccelTable;
	hInstance=hInst;

	// Inizializzare le stringhe globali
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_FRACTALS, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Eseguire l'inizializzazione dall'applicazione:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_FRACTALS);

	// Ciclo di messaggi principale:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int) msg.wParam;
}

//
//  FUNZIONE: MyRegisterClass()
//
//  SCOPO: registra la classe di finestre.
//
//  COMMENTI:
//
//    Questa funzione e il relativo utilizzo sono necessari solo se si desidera che il codice
//    sia compatibile con i sistemi Win32 precedenti alla funzione 'RegisterClassEx'
//    aggiunta a Windows 95.  importante chiamare questa funzione
//    in modo da ottenere piccole icone in formato corretto associate
//    all'applicazione.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, (LPCTSTR)IDI_FRACTALS);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1+7*0);
	wcex.lpszMenuName	= (LPCTSTR)IDC_FRACTALS;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);

	return RegisterClassEx(&wcex);
}

//
//   FUNZIONE: InitInstance(HANDLE, int)
//
//   SCOPO: salva l'handle di istanza e crea la finestra principale
//
//   COMMENTI:
//
//        In questa funzione l'handle di istanza viene salvato in una variabile globale e
//        la finestra di programma principale viene creata e visualizzata.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; // Memorizzare l'handle di istanza nella variabile globale

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

#define PI (atan(1.)*4.)
void BinTree(HWND hWnd,HDC hdc,int depth,float dtheta,float length_scale)
{
dtheta=(dtheta*PI)/180.;
int taper=depth;
float length=0;
RECT rc;

  GetClientRect(hWnd,&rc);
 int rcWidth = rc.right -rc.left;
  int rcHeight = rc.bottom -rc.top;
  
  	length = (rcHeight -10)/((1 - pow(length_scale,depth+1))/(1 - length_scale));
    DrawBranch (hdc,taper, depth,  rcWidth / 2, rcHeight - 5, length,  length_scale, -PI / 2, dtheta);


}

void BinTree2(HWND hWnd,HDC hdc,int depth,float dtheta)
{
float start_length=0.;
float length_scale=0.65;

dtheta=dtheta*PI/180.;

RECT rc;

  GetClientRect(hWnd,&rc);
  int rcWidth = rc.right -rc.left;
  int rcHeight = rc.bottom -rc.top;

    start_length = (rcHeight - 10) / ((1 - pow(length_scale ,depth + 1)) / (1 - length_scale));

    DrawBranch2(hdc, depth, rcWidth / 2, rcHeight - 5, start_length, -dtheta,dtheta,length_scale);
}

void Tree(HWND hWnd,HDC hdc, float thickness,int Depth,float X, float Y,float length,float length_scale,float rnd_scale,float theta, float dtheta,float rnd_dtheta,int max_branches)
{
srand((unsigned)time(0));
theta=(theta*PI)/180.;
dtheta=(dtheta*PI)/180.;
rnd_dtheta=(rnd_dtheta*PI)/180.;
float bend=0;//PI/90.;//0

RECT rc;

  GetClientRect(hWnd,&rc);
 int rcWidth = rc.right -rc.left;
  int rcHeight = rc.bottom -rc.top;
 
    length = (rcHeight - 10) / ((1 - pow(length_scale ,Depth + 1)) / (1 - length_scale));

	int N=1;
	for(int i=0; i <N;i++)
	{

		bend = PI/(90.-i*10); 
		DrawBranch3(hdc, bend, thickness, Depth, 
        rcWidth / 2+X, 
        rcHeight - 5+Y, 
        length, length_scale, rnd_scale, 
        -PI / 2, dtheta, rnd_dtheta, max_branches);
	}
}

void Hilbert(HWND hWnd, HDC hdc,int depth)
{
	float total_length=0;
	float start_x=0;
	float start_y=0;
	float start_length=0;
	

	RECT rc;
	GetClientRect(hWnd,&rc);
	int rcWidth = rc.right -rc.left;
	int rcHeight = rc.bottom -rc.top;
  
    if (rcHeight < rcWidth)
        total_length = 0.9 * rcHeight;
    else
        total_length = 0.9 * rcWidth;
   
    start_x = (rcWidth - total_length) / 2;
    start_y = (rcHeight - total_length) / 2;

    start_length = total_length / (pow(2, depth) - 1);
    
    MoveToEx(hdc,start_x,start_y,NULL);
    calcHilbert (hdc,depth, start_length, 0);
}

void FlakeAnim(HWND hWnd, HDC hdc,int depth, float theta)
{
	theta = (theta *PI)/180.;
	float length = 0;
	float unit = 0;
	float vunit = 0;
	float hunit = 0;


	RECT rc;
	GetClientRect(hWnd,&rc);
	int rcWidth = rc.right -rc.left;
	int rcHeight = rc.bottom -rc.top;

	vunit = 0.9 * rcHeight / (sqrt(3.) * 4. / 3.);
    hunit = 0.9 * rcWidth / 2.;
    if (vunit < hunit)
        unit = vunit;
	else
        unit = hunit;
    
    length = 2 * unit;

    // Initialize the generator and initiator.
    InitializeGenerator (hdc, theta, length);

    // Draw the animation frames.
    MakeMovie (hdc, depth, length);

}

typedef struct BinTreeParams
{
	int depth=15;
	float dtheta=36;
	float length_scale=0.75;
}BinTreeParams;
class clsBinTree: public IFractal{
public:
	BinTreeParams binTreeParams;
	char *toString(){
		return "BIN TREE";
	}
	void draw(HWND hWnd, HDC hdc){
			BinTree(hWnd,hdc,binTreeParams.depth,binTreeParams.dtheta,binTreeParams.length_scale);
	}
};

typedef struct BinTree2Params
{
	int depth=11;
	float dtheta=90;
}BinTree2Params;
class clsBinTree2: public IFractal{
public:
	BinTree2Params binTree2Params;
	char *toString(){
		return "BIN TREE 2";
	}
	void draw(HWND hWnd, HDC hdc){
			BinTree2(hWnd,hdc,binTree2Params.depth,binTree2Params.dtheta);
	}
};

typedef struct TreeParams
{
int depth=9;
int thickness=9;
float length=0;
float length_scale=0.75;
float rnd_scale=0.2;
float theta=-90;
float dtheta=36.;
float rnd_dtheta=20.;
float X=0;
float Y=0;
int max_branches=3;
}TreeParams;
class clsTree: public IFractal{
public:
	TreeParams treeParams;
		char *toString(){
		return "TREE";
	}
	void draw(HWND hWnd, HDC hdc){
		Tree(hWnd,hdc, treeParams.thickness,treeParams.depth,treeParams.X, treeParams.Y,treeParams.length,treeParams.length_scale,treeParams.rnd_scale,-PI/2.,treeParams.dtheta,treeParams.rnd_dtheta,treeParams.max_branches);

	}
};

typedef struct HilbertParams
{
int depth=5;

}HilbertParams;
class clsHilbert: public IFractal{
public:
	HilbertParams hilbertParams;
		char *toString(){
		return "HILBERT";
	}
	void draw(HWND hWnd, HDC hdc){
		Hilbert(hWnd, hdc, hilbertParams.depth);

	}
};

typedef struct FlakeAnimParams
{
	int depth = 5;
	float theta = 60.;
}FlakeAnimParams;
class clsFlakeAnim: public IFractal{
	public:
	FlakeAnimParams flakeAnimParams;
	char *toString(){
		return "FLAKE ANIM";
	}
	void draw(HWND hWnd, HDC hdc){
		FlakeAnim(hWnd, hdc, flakeAnimParams.depth, flakeAnimParams.theta);

	}
};

IFractal *_pFractal=NULL;
clsBinTree* _pBinTree= NULL;
clsBinTree2* _pBinTree2= NULL;
clsHilbert* _pHilbert= NULL;
clsFlakeAnim* _pFlakeAnim=NULL;
clsTree* _pTree= NULL;
clsValley *_pValley = NULL;

void DumpAddr(void *p,char *msg){
	sprintf(buff,"%p",&p);
	MessageBox(NULL,buff , msg, MB_OK);
}
LRESULT CALLBACK BinTreeDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	static LPARAM loParam=NULL;
	switch (message)
	{
	case WM_INITDIALOG:
		{
			SetWindowText(hDlg,"BIN TREE");
			
			loParam = lParam;
			clsBinTree *pBinTree = reinterpret_cast<clsBinTree*>(lParam);
			BinTreeParams pBinTreeParams = pBinTree->binTreeParams;
			
			itoa(pBinTreeParams.depth,buff,10);
			SetDlgItemText(hDlg,IDC_DEPTH,buff);
			sprintf(buff, "%.2f", pBinTreeParams.dtheta);
			SetDlgItemText(hDlg,IDC_DTHETA,buff);
			sprintf(buff, "%.2f", pBinTreeParams.length_scale);
			SetDlgItemText(hDlg,IDC_SCALE,buff);
			//DumpAddr((void*)_pBinTree,"C");
			
		}
		return TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK)
		{
			
			clsBinTree *pBinTree = reinterpret_cast<clsBinTree*>(loParam);
			if (GetDlgItemText(hDlg, IDC_DEPTH, buff, BUFF_SIZE)){
				pBinTree->binTreeParams.depth = atoi(buff);
			}
			if (GetDlgItemText(hDlg, IDC_DTHETA, buff, BUFF_SIZE)) 
				pBinTree->binTreeParams.dtheta = atof(buff);
			if (GetDlgItemText(hDlg, IDC_SCALE, buff, BUFF_SIZE)) 
				pBinTree->binTreeParams.length_scale = atof(buff);
						
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		if(LOWORD(wParam) == IDCANCEL) 
		{
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		break;
	}
	return FALSE;
}

LRESULT CALLBACK BinTree2DlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	static LPARAM loParam=NULL;
	switch (message)
	{
	case WM_INITDIALOG:
		{
			SetWindowText(hDlg,"BIN TREE 2");
			loParam = lParam;
			clsBinTree2 *pBinTree = reinterpret_cast<clsBinTree2*>(lParam);
			
			itoa(pBinTree->binTree2Params.depth,buff,10);
			SetDlgItemText(hDlg,IDC_DEPTH,buff);
			sprintf(buff, "%.2f", pBinTree->binTree2Params.dtheta);
			SetDlgItemText(hDlg,IDC_DTHETA,buff);


		}
		return TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK)
		{
			clsBinTree2 *pBinTree = reinterpret_cast<clsBinTree2*>(loParam);
						

			if (GetDlgItemText(hDlg, IDC_DEPTH, buff, BUFF_SIZE)){
				pBinTree->binTree2Params.depth = atoi(buff);
			}

			if (GetDlgItemText(hDlg, IDC_DTHETA, buff, BUFF_SIZE)) 
				pBinTree->binTree2Params.dtheta = atof(buff);

			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		if(LOWORD(wParam) == IDCANCEL) 
		{
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		break;
	}
	return FALSE;
}

LRESULT CALLBACK TreeDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	static LPARAM loParam=NULL;
	switch (message)
	{
	case WM_INITDIALOG:
		{
			SetWindowText(hDlg,"TREE");

			loParam = lParam;
			clsTree *pBinTree = reinterpret_cast<clsTree*>(lParam);
			
			itoa(pBinTree->treeParams.depth,buff,10);
			SetDlgItemText(hDlg,IDC_DEPTH,buff);
			
			sprintf(buff, "%.2f", pBinTree->treeParams.dtheta);
			SetDlgItemText(hDlg,IDC_DTHETA,buff);
			
			sprintf(buff, "%.2f", pBinTree->treeParams.length_scale);
			SetDlgItemText(hDlg,IDC_SCALE,buff);
			
			sprintf(buff, "%.2f", pBinTree->treeParams.X);
			SetDlgItemText(hDlg,IDC_X,buff);
			
			sprintf(buff, "%.2f", pBinTree->treeParams.Y);
			SetDlgItemText(hDlg,IDC_Y,buff);
			
			sprintf(buff, "%d", pBinTree->treeParams.thickness);
			SetDlgItemText(hDlg,IDC_THICKNESS,buff);
			
			sprintf(buff, "%.2f", pBinTree->treeParams.theta);
			SetDlgItemText(hDlg,IDC_THETA,buff);
			
			sprintf(buff, "%.2f", pBinTree->treeParams.rnd_scale);
			SetDlgItemText(hDlg,IDC_RND_SCALE,buff);
			
			sprintf(buff, "%.2f", pBinTree->treeParams.rnd_dtheta);
			SetDlgItemText(hDlg,IDC_RND_THETA,buff);
			
			sprintf(buff, "%.2f", pBinTree->treeParams.length);
			SetDlgItemText(hDlg,IDC_LENGTH,buff);
			
			sprintf(buff, "%d", pBinTree->treeParams.max_branches);
			SetDlgItemText(hDlg,IDC_MAX_BRANCHES,buff);

		}
		return TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK)
		{
			clsTree *pBinTree = reinterpret_cast<clsTree*>(loParam);
						

			if (GetDlgItemText(hDlg, IDC_DEPTH, buff, BUFF_SIZE)){
				pBinTree->treeParams.depth = atoi(buff);
			}

			if (GetDlgItemText(hDlg, IDC_DTHETA, buff, BUFF_SIZE)) 
				pBinTree->treeParams.dtheta = atof(buff);
			if (GetDlgItemText(hDlg, IDC_SCALE, buff, BUFF_SIZE)) 
				pBinTree->treeParams.length_scale = atof(buff);

			if (GetDlgItemText(hDlg, IDC_X, buff, BUFF_SIZE)) 
				pBinTree->treeParams.X = atof(buff);
			if (GetDlgItemText(hDlg, IDC_Y, buff, BUFF_SIZE)) 
				pBinTree->treeParams.Y = atof(buff);
			

			if (GetDlgItemText(hDlg, IDC_THICKNESS, buff, BUFF_SIZE)) 
				pBinTree->treeParams.thickness = atof(buff);
			
			
			if (GetDlgItemText(hDlg, IDC_THETA, buff, BUFF_SIZE)) 
				pBinTree->treeParams.theta = atof(buff);
			
			
			if (GetDlgItemText(hDlg, IDC_RND_SCALE, buff, BUFF_SIZE)) 
				pBinTree->treeParams.rnd_scale = atof(buff);
			
			if (GetDlgItemText(hDlg, IDC_RND_THETA, buff, BUFF_SIZE)) 
				pBinTree->treeParams.rnd_dtheta = atof(buff);

			if (GetDlgItemText(hDlg, IDC_LENGTH, buff, BUFF_SIZE)) 
				pBinTree->treeParams.length = atof(buff);

			if (GetDlgItemText(hDlg, IDC_MAX_BRANCHES, buff, BUFF_SIZE)) 
				pBinTree->treeParams.max_branches = atof(buff);
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		if(LOWORD(wParam) == IDCANCEL) 
		{
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		break;
	}
	return FALSE;
}

LRESULT CALLBACK HilbertDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	static LPARAM loParam=NULL;
	switch (message)
	{
	case WM_INITDIALOG:
		{
			SetWindowText(hDlg,"HILBERT");
			loParam = lParam;
			clsHilbert *pHilbert = reinterpret_cast<clsHilbert*>(lParam);

			itoa(pHilbert->hilbertParams.depth,buff,10);
			SetDlgItemText(hDlg,IDC_DEPTH,buff);
		}
		return TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK)
		{
			clsHilbert *pHilbert = reinterpret_cast<clsHilbert*>(loParam);
						

			if (GetDlgItemText(hDlg, IDC_DEPTH, buff, BUFF_SIZE)){
				pHilbert->hilbertParams.depth = atoi(buff);
			}
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		if(LOWORD(wParam) == IDCANCEL) 
		{
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		break;
	}
	return FALSE;
}

LRESULT CALLBACK FlakeAnimDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	static LPARAM loParam=NULL;
	switch (message)
	{
	case WM_INITDIALOG:
		{
			SetWindowText(hDlg,"FLAKE ANIM");
			loParam = lParam;
			clsFlakeAnim *pBinTree = reinterpret_cast<clsFlakeAnim*>(lParam);

			itoa(pBinTree->flakeAnimParams.depth,buff,10);
			SetDlgItemText(hDlg,IDC_DEPTH,buff);
			sprintf(buff, "%.2f", pBinTree->flakeAnimParams.theta);
			SetDlgItemText(hDlg,IDC_THETA,buff);


		}
		return TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK)
		{
			clsBinTree2 *pBinTree = reinterpret_cast<clsBinTree2*>(loParam);
						

			if (GetDlgItemText(hDlg, IDC_DEPTH, buff, BUFF_SIZE)){
				pBinTree->binTree2Params.depth = atoi(buff);
			}

			if (GetDlgItemText(hDlg, IDC_THETA, buff, BUFF_SIZE)) 
				pBinTree->binTree2Params.dtheta = atof(buff);

			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		if(LOWORD(wParam) == IDCANCEL) 
		{
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		break;
	}
	return FALSE;
}

LRESULT CALLBACK ValleyDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	static LPARAM loParam=NULL;
	switch (message)
	{
	case WM_INITDIALOG:
		{
			SetWindowText(hDlg,"VALLEY");
			loParam = lParam;
			clsValley *pValley = reinterpret_cast<clsValley*>(lParam);
			
			itoa(pValley->valleyParams.levels,buff,10);
			SetDlgItemText(hDlg,IDC_LEVELS,buff);
			sprintf(buff, "%.2f", pValley->valleyParams.dyvs);
			SetDlgItemText(hDlg,IDC_DIV,buff);


		}
		return TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK)
		{
			clsValley *pValley = reinterpret_cast<clsValley*>(loParam);
						

			if (GetDlgItemText(hDlg, IDC_LEVELS, buff, BUFF_SIZE)){
				pValley->valleyParams.levels = atoi(buff);
			}

			if (GetDlgItemText(hDlg, IDC_DIV, buff, BUFF_SIZE)) 
				pValley->valleyParams.dyvs = atof(buff);

			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		if(LOWORD(wParam) == IDCANCEL) 
		{
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		break;
	}
	return FALSE;
}

//
//  FUNZIONE: WndProc(HWND, unsigned, WORD, LONG)
//
//  SCOPO:  elabora i messaggi per la finestra principale.
//
//  WM_COMMAND	- elabora il menu dell'applicazione
//  WM_PAINT	- Disegna la finestra principale
//  WM_DESTROY	- inserisce un messaggio di uscita e restituisce un risultato
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;
	
	switch (message) 
	{
	case WM_COMMAND:
		wmId    = LOWORD(wParam); 
		wmEvent = HIWORD(wParam); 
		// Analizzare le selezioni di menu:
		switch (wmId)
		{
		case IDM_ABOUT:
			DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		case IDM_BIN_TREE:
			{
				if(NULL == _pBinTree){
					_pBinTree = new clsBinTree();
				}
			
				if(IDOK ==DialogBoxParam(hInstance, MAKEINTRESOURCE(IDD_BIN_TREE), hWnd, reinterpret_cast<DLGPROC>(BinTreeDlgProc),(LPARAM)_pBinTree)){
					_pFractal = _pBinTree;
					RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
				}
			}
			
			break;	
			
			case IDM_BIN_TREE2:
			{
				if(NULL == _pBinTree2){
					_pBinTree2 = new clsBinTree2();
				}
				
				if(IDOK ==DialogBoxParam(hInstance, MAKEINTRESOURCE(IDD_BIN_TREE2), hWnd, reinterpret_cast<DLGPROC>(BinTree2DlgProc),(LPARAM)_pBinTree2)){
					_pFractal = _pBinTree2;
					RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
				}
			}
			break;	
			case IDM_TREE:
			{
				if(NULL == _pTree){
					_pTree = new clsTree();
				}
				
				if(IDOK ==DialogBoxParam(hInstance, MAKEINTRESOURCE(IDD_TREE), hWnd, reinterpret_cast<DLGPROC>(TreeDlgProc),(LPARAM)_pTree)){
					_pFractal = _pTree;
					RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
				}
			}
			break;	
			case IDM_HILBERT:
			{
				if(NULL == _pHilbert){
					_pHilbert = new clsHilbert();

				}
				
				if(IDOK ==DialogBoxParam(hInstance, MAKEINTRESOURCE(IDD_HILBERT), hWnd, reinterpret_cast<DLGPROC>(HilbertDlgProc),(LPARAM)_pHilbert)){
					_pFractal = _pHilbert;
					RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
				}
			}
			break;	
			case IDM_FLAKEANIM:
			{
				if(NULL == _pFlakeAnim){
					_pFlakeAnim = new clsFlakeAnim();

				}
				
				if(IDOK ==DialogBoxParam(hInstance, MAKEINTRESOURCE(IDD_FLAKEANIM), hWnd, reinterpret_cast<DLGPROC>(FlakeAnimDlgProc),(LPARAM)_pFlakeAnim)){
					_pFractal = _pFlakeAnim;
					RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
				}
			}
			break;	
			case IDM_VALLEY:
			{
				if(NULL == _pValley){
					_pValley = new clsValley();

				}

				if(IDOK ==DialogBoxParam(hInstance, MAKEINTRESOURCE(IDD_VALLEY), hWnd, reinterpret_cast<DLGPROC>(ValleyDlgProc),(LPARAM)_pValley)){
					_pFractal = _pValley;
					RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
				}
				
			}
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_PAINT:
		InvalidateRect(hWnd,NULL,true);//Cancella lo sfondo
		hdc = BeginPaint(hWnd, &ps);

		if(NULL!=_pFractal){
			SetWindowText(hWnd,_pFractal->toString());
			_pFractal->draw(hWnd,hdc);
		}

		EndPaint(hWnd, &ps);
		break;
		
		case WM_CHAR:
		{
			
			if(_pFractal == NULL || (typeid(*_pFractal))!=typeid(clsValley))
				return 0;

            switch (wParam)
            {
			case '+':
				{
			        _pValley->EyeR -= _pValley->Dr;
					RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
			
					break;
				}
			case '-':
				{
					_pValley->EyeR += _pValley->Dr;
					RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
					break;
				}
			}
		}
		break;

		   case WM_KEYDOWN:
		   {
			switch (wParam)
            {
			case VK_SPACE: 
				{
					RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
					break;
				}
				break;
			}
			if(_pFractal == NULL || (typeid(*_pFractal))!=typeid(clsValley))
				return 0;
            switch (wParam)
            {
                case VK_LEFT: 
					{
						_pValley->EyeTheta -= _pValley->Dtheta;
						RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
						break;
					}
                case VK_UP:
					{
						_pValley->EyePhi -= _pValley->Dphi;
						RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
   						break;
					}
                case VK_RIGHT: 
					{
						_pValley->EyeTheta += _pValley->Dtheta;
						RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
  					break;
					}
                case VK_DOWN: 
					{
						_pValley->EyePhi += _pValley->Dphi;
						RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
  						break;
					}
            }
		   }
            break;
		
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}


// Recursively draw a tree branch.
void DrawBranch(HDC hdc, float thickness, int depth, float X, float Y, float length, float length_scale,float theta,float dtheta)
{
	Sleep(iDelay);
	float x1 =0;
	float y1=0;
	int status  = 0;


    x1 = X + length * cos(theta);
    y1 = Y + length * sin(theta);
 
	MoveToEx(hdc,X, Y,NULL);
    LineTo(hdc,x1, y1);
    
    // If depth > 1, draw the attached branches.
    if( depth > 1)
	{
        DrawBranch(hdc, thickness - 1, depth - 1, x1, y1, length * length_scale, length_scale, theta + dtheta, dtheta);
        DrawBranch(hdc, thickness - 1, depth - 1, x1, y1, length * length_scale, length_scale, theta - dtheta, dtheta);
	}
}

void DrawBranch2(HDC hdc, int depth, float X,float Y, float length,float theta, float dtheta,float length_Scale)
{
	float x1 =0;
	float y1=0;

    // See where this branch should end.
    x1 = X + length * cos(theta);
    y1 = Y + length * sin(theta);
	MoveToEx(hdc,X, Y,NULL);
    LineTo(hdc,x1, y1);
    // If depth > 1, draw the attached branches.
    if (depth > 1)
	{
        DrawBranch2(hdc, depth - 1, x1, y1, length * length_Scale, theta + dtheta, dtheta,length_Scale);
        DrawBranch2 (hdc, depth - 1, x1, y1, length * length_Scale, theta - dtheta, dtheta,length_Scale);
    }
}

void DrawBranch3(HDC hdc, float bend, float thickness,int Depth,float X, float Y,float length,float length_scale,float rnd_scale,float theta, float dtheta,float rnd_dtheta,int max_branches)
{
const float DIST_PER_BEND = 5.;
const float BEND_FACTOR = 2.;
const float MAX_BEND = PI / 6.;

int x1=0;
int y1=0;
int x2=0;
int y2=0;
int status=0;
int num_bends=0;
int num_branches=0;
int i=0;
int new_length=0;
float new_theta=0;
float new_bend=0;
float dt=0;
float t=0;
HPEN hPenOri = NULL,hPen=NULL;
//Sleep(100);

    if (thickness > 0) 
	{
			hPen = CreatePen(PS_INSIDEFRAME,thickness,RGB(0,0,0));
			hPenOri = (HPEN)SelectObject(hdc, hPen);
	}

    // Draw the branch.
    if (bend > 0)
	{
        // This is a bending branch.
        num_bends = length / DIST_PER_BEND;
        t = theta;
        x1 = X;
        y1 = Y;
        for (i = 0; i< num_bends; i++)
		{
            x2 = x1 + DIST_PER_BEND * cos(t);
            y2 = y1 + DIST_PER_BEND * sin(t);
    
			MoveToEx(hdc,x1,y1,NULL);
			LineTo(hdc,x2, y2);
        
            t = t + bend * (myrand() - 0.5);
            x1 = x2;
            y1 = y2;
		}
	}
	else
	{
        // This is a straight branch.
        x1 = X + length * cos(theta);
        y1 = Y + length * sin(theta);
      		MoveToEx(hdc,X,Y,NULL);
			LineTo(hdc,x1, y1);
	}

    // If depth > 1, draw the attached branches.
    if (Depth > 1)
	{
        num_branches = int((max_branches - 1) * myrand() + 2);
        dt = 2 * dtheta / (num_branches - 1);
        t = theta - dtheta;
        for(i=0; i< num_branches;i++)
		{
            new_length = length * (length_scale + rnd_scale * (myrand() - 0.5));
            new_theta = t + rnd_dtheta * (myrand() - 0.5);
            t = t + dt;
            if (bend > 0)
			{
                new_bend = bend * BEND_FACTOR;
                if (new_bend > MAX_BEND) 
					 new_bend = MAX_BEND;
			}
			else
                new_bend = bend;
            
            DrawBranch3(hdc, new_bend, thickness - 1, 
                Depth - 1, x1, y1, new_length, 
                length_scale, rnd_scale, new_theta, 
                dtheta, rnd_dtheta, max_branches);
			Sleep(iDelay);
		}
	}

	if(hPen)
	{
			SelectObject(hdc, hPenOri);
			DeleteObject(hPen);
	}
}

void LineStep(HDC hdc,int dx, int dy)
{
	POINT pCurr;
	GetCurrentPositionEx(hdc, &pCurr);
    LineTo(hdc, pCurr.x +dx, pCurr.y + dy);
	MoveToEx(hdc,pCurr.x +dx, pCurr.y +dy,NULL);
}


void calcHilbert(HDC hdc, int depth ,float dx,float dy)
{
	Sleep(iDelay);
	if (depth > 1) 
		calcHilbert(hdc, depth - 1, dy, dx);
    LineStep(hdc,dx,dy);
    if (depth > 1)
		calcHilbert(hdc, depth - 1, dx, dy);
    LineStep(hdc,dy, dx);
    if (depth > 1)
		calcHilbert(hdc, depth - 1, dx, dy);
    LineStep(hdc,-dx, -dy);
    if( depth > 1)
		calcHilbert(hdc, depth - 1, -dy, -dx);
}

// Coordinates of the points in the initiator.
const int NUM_INITIATOR_POINTS = 4;
float InitiatorX[NUM_INITIATOR_POINTS];
float InitiatorY[NUM_INITIATOR_POINTS];

// Angles and distances for the generator.
const int NUM_GENERATOR_ANGLES = 4;
float ScaleFactor=0;
float GeneratorDTheta[NUM_GENERATOR_ANGLES];

void DrawFlakeEdge(HDC hdc,int depth, float &x1, float &y1, float theta,float dist,float offset)
{
	int status=0;
	int i=0;
	float x2=0;
	float y2=0;
	float new_theta=0;
	float dtheta=0;
	float hyp=0;
	float adj=0;

    if (depth <= 1)
	{
        //' Draw the final depth.
        dist = dist * ScaleFactor;
        adj = dist * cos(GeneratorDTheta[1]);
        hyp = sqrt(adj * adj + offset * offset);
        x2 = x1 + dist * cos(theta);
        y2 = y1 + dist * sin(theta);
		MoveToEx(hdc,x1, y1,NULL);
        LineTo(hdc, x2, y2);
        x1 = x2;
        y1 = y2;
        
        dtheta = atan2(offset, adj);
        new_theta = theta + dtheta;
        x2 = x1 + hyp * cos(new_theta);
        y2 = y1 + hyp * sin(new_theta);
		MoveToEx(hdc,x1, y1,NULL);
        LineTo(hdc, x2, y2);
        x1 = x2;
        y1 = y2;
        
        new_theta = theta - dtheta;
        x2 = x1 + hyp * cos(new_theta);
        y2 = y1 + hyp * sin(new_theta);
  		MoveToEx(hdc,x1, y1,NULL);
        LineTo(hdc, x2, y2);
        x1 = x2;
        y1 = y2;
        
        x2 = x1 + dist * cos(theta);
        y2 = y1 + dist * sin(theta);
      	MoveToEx(hdc,x1, y1,NULL);
        LineTo(hdc, x2, y2);
		x1 = x2;
        y1 = y2;
        
        return;
	}
    
    //' Recursively draw the edge.
    dist = dist * ScaleFactor;
    for( i = 0; i < NUM_GENERATOR_ANGLES;i++)
	{
        theta = theta + GeneratorDTheta[i];
        DrawFlakeEdge(hdc, depth - 1, x1, y1, theta, dist, offset);
	}
}

// Draw the complete snowflake.
void DrawFlake(HDC hdc,int depth, float length,float offset)
{
	int i=0;
	float x1=0;
	float y1=0;
	float x2=0;
	float y2=0;
	float dx=0;
	float dy=0;
	float theta=0;

	HWND hWnd = WindowFromDC(hdc);
	RECT rc;
	GetClientRect(hWnd,&rc);
	Rectangle(hdc,rc.left,rc.top,rc.right,rc.bottom);   

    for( i = 1; i < NUM_INITIATOR_POINTS; i++)
	{
		x1 = InitiatorX[i-1];
        y1 = InitiatorY[i-1];
        x2 = InitiatorX[i];
        y2 = InitiatorY[i];
        dx = x2 - x1;
        dy = y2 - y1;
        theta = atan2(dy, dx);
        DrawFlakeEdge (hdc, depth, x1, y1, 
            theta, length, offset);
	}
}

// Draw the animation frames.
void MakeMovie(HDC hdc, int depth,float length)
{
	const int FRAMES_PER_DEPTH = 20;
	const int MS_PER_FRAME = 50;

	int i=0;
	int max_depth=0;
	float offset=0;
	float doffset=0;
	long next_time=0;

    // Draw the animation frames.
    max_depth = depth;
    next_time = GetTickCount();
    for (depth = 1 ; depth < max_depth; depth++)
	{
        doffset = length * pow(ScaleFactor , depth) * 
            sin(GeneratorDTheta[1]) / FRAMES_PER_DEPTH;
        offset = doffset;

        for( i =0; i < FRAMES_PER_DEPTH; i++)
		{
			Sleep(iDelay);
    		DrawFlake (hdc, depth, length, offset);

            offset += doffset;
            next_time += MS_PER_FRAME;
		}
	}
}

// Initialize the generator for the indicated angle.
void InitializeGenerator(HDC hdc, float theta, float length)
{
float xmid=0;
float ymid=0;
HWND hWnd = WindowFromDC(hdc);
RECT rc;
GetClientRect(hWnd,&rc);
int rcWidth = rc.right -rc.left;
int rcHeight = rc.bottom -rc.top;

    //' Initialize the initiator's coordinates.
    xmid = rcWidth / 2;
    ymid = rcHeight / 2;
    InitiatorX[1] = xmid + length / 2;
    InitiatorY[1] = ymid - length / 2 * sqrt(3.) / 3;
    InitiatorX[2] = xmid - length / 2;
    InitiatorY[2] = InitiatorY[1];
	InitiatorX[3] = xmid;
    InitiatorY[3] = ymid + length / 2 * sqrt(3.) * 2 / 3;
    InitiatorX[0] = InitiatorX[3];
    InitiatorY[0] = InitiatorY[3];

    ScaleFactor = 1 / (2 * (1 + cos(theta)));
    GeneratorDTheta[0] = 0;
    GeneratorDTheta[1] = theta;
    GeneratorDTheta[2] = -2 * theta;
    GeneratorDTheta[3] = theta;
}
// Gestore dei messaggi della finestra Informazioni su.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_INITDIALOG:
		return TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
		{
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		break;
	}
	return FALSE;
}
