
#include "M3Ops.h"
#include "ValleyGrid3d.h"
#include "Valley.h"
#include <ctime>
using namespace std;

	clsValley::clsValley(){
		EyeR = 10;
		EyeTheta = M_PI * 0.2;
		EyePhi = M_PI * 0.1;
		
    }
	char* clsValley::toString(){
		return "VALLEY";
	}

	void clsValley::draw(HWND hWnd,HDC hdc)
	{
		m3PProject (Projector, m3Perspective, EyeR, EyePhi, EyeTheta, FocusX, FocusY, FocusZ, 0, 1, 0);
		float X=0;
		float Y=0;
		float Z=0;
		float S[4][4];
		float T[4][4];
		float ST[4][4];
		float PST[4][4];

		if (NULL ==hWnd)
			hWnd = WindowFromDC(hdc);
		RECT rc;
		GetClientRect(hWnd,&rc);
		float StartX=(rc.right-rc.left)/2.;
		float StartY=(rc.bottom -rc.top)/2.;
		float StartZ =0;
		float StartScale = 35;

		CreateData();

		// Scale and translate so it looks OK in pixels.
		m3Scale (S, StartScale, -StartScale, 1);
		m3Translate (T, StartX, StartY, 0);
		m3MatMultiplyFull (ST, S, T);
		m3MatMultiplyFull (PST, Projector, ST);

		// Transform the points.
		TheGrid->ApplyFull(PST);


		picCls(hdc);
		TheGrid->RemoveHidden = true;
		TheGrid->Draw(hdc);
		
	}