#include "stdafx.h"
#include "M3Ops.h"
#include <iostream>
#include <cmath>
#include <climits>
using namespace std;

#define MYINFINITY  INT_MAX;

struct Segment3D
{
	int pt1;
    int pt2;
};

void m3SphericalToCartesian(float R, float theta, float phi, float &X, float &Y, float &Z)
{
float r2 = 0;
    
    // Create a line to the center of projection.
    Y = R * sin(phi);
    r2 = R * cos(phi);
    X = r2 * cos(theta);
    Z = r2 * sin(theta);
}

// Create a transformation matrix for an oblique
// projection onto the X-Y plane.
void m3ObliqueXY(float M[4][4], float S, float theta)
{
    m3Identity (M);
    M[2][0] = -S * cos(theta);
    M[2][1] = -S * sin(theta);
    M[2][2] = 0;
}

// Create a transformation matrix for orthographic
// projection along the X axis.
void m3OrthoSide(float M[4][4])
{
    m3Identity (M);
    M[0][0] = 0;
    M[2][0] = -1;
    M[2][2] = 0;
}

// Create a transformation matrix for orthographic
// projection along the Y axis.
void m3OrthoTop(float M[4][4])
{
    m3Identity (M);
    M[1][1] = 0;
    M[2][1] = -1;
    M[2][2] = 0;
}

// Create a transformation matrix for orthographic
// projection along the Z axis.
void m3OrthoFront(float M[4][4])
{
    m3Identity (M);
    M[2][2] = 0;
}

// Create an identity matrix.
void m3Identity(float M[4][4])
{
int i=0;
int j=0;

    for( i = 0; i < 4; i++)
	{
        for( j = 0; j < 4; j++)
		{
            if (i == j)
                M[i][j] = 1;
            else
                M[i][j] = 0;
		}
	}
}

// Normalize a 3-D point vector.
void m3NormalizeCoords(float &X, float &Y, float &Z, float &S)
{
    X = X / S;
    Y = Y / S;
    Z = Z / S;
    S = 1;
}

// Normalize a 3-D point vector.
void m3NormalizePoint(float P[])
{
int i=0;
float value=0;

    value = P[4];
    for(i =0; i < 3; i++)
        P[i] = P[i] / value;
    
    P[3] = 1;
}


// Normalize a 3-D transformation matrix.
void m3NormalizeMatrix(float *M[])
{
int i=0;
int j=0;
float value=0;

    value = M[3][3];
    for(i=0; i < 4; i++)
        for( j = 0; j < 4; j++)
            M[i][j] = M[i][j] / value;
}

// Create a 3-D transformation matrix for a
// perspective projection along the Z axis onto
// the X-Y plane with focus at the origin and the
// center of projection at distance (0, 0, D).
void m3PerspectiveXZ(float M[4][4], float D)
{
    m3Identity (M);
    if (D != 0)
		M[2][3] = -1.f / D;
}

// Create a 3-D transformation matrix for a
// projection with:
//       center of projection    (cx, cy, cz)
//       focus                   (fx, fy, fx)
//      UP vector               <ux, yx, uz>
// ptype should be m3Perspective or m3Parallel.
void m3Project(float M[4][4],int ptype, float Cx, float Cy, float Cz, float Fx, float Fy, float Fz, float ux,float uy, float uz)
{
	static float M1[4][4];
	static float M2[4][4];
	static float M3[4][4];
	static float M4[4][4];
	static float M5[4][4];
	static float M12[4][4];
	static float M34[4][4];
	static float M1234[4][4];
	float sin1=0;
	float cos1=0;
	float sin2=0;
	float cos2=0;
	float sin3=0;
	float cos3=0;
	float A=0;
	float B=0;
	float C=0;
	float d1=0;
	float d2=0;
	float d3=0;
	float up1[4];
	float up2[4];

    // Translate the focus to the origin.
    m3Translate (M1, -Fx, -Fy, -Fz);

    A = Cx - Fx;
    B = Cy - Fy;
    C = Cz - Fz;
    d1 = sqrt(A * A + C * C);
    if (d1 != 0.)
	{
        sin1 = -A / d1;
        cos1 = C / d1;
	}
    d2 = sqrt(A * A + B * B + C * C);
    if (d2 !=0)
	{
        sin2 = B / d2;
        cos2 = d1 / d2;
	}
    
    // Rotate around the Y axis to place the
    // center of projection in the Y-Z plane.
    m3Identity (M2);
    
    // If d1 = 0 then the center of projection
    // already lies in the Y axis and thus the Y-Z plane.
    if (d1 !=0)
	{
        M2[0][0] = cos1;
        M2[0][2] = -sin1;
        M2[2][0] = sin1;
        M2[2][2] = cos1;
	}
    
    // Rotate around the X axis to place the
    // center of projection in the Z axis.
    m3Identity (M3);
    
    // If d2 = 0 then the center of projection
    // lies at the origin. This makes projection
    // impossible.
    if (d2 !=0)
	{
        M3[1][1] = cos2;
        M3[1][2] = sin2;
        M3[2][1] = -sin2;
        M3[2][2] = cos2;
	}
    
    // Apply the rotations to the UP vector.
    up1[0] = ux;
    up1[1] = uy;
    up1[2] = uz;
    up1[3] = 1;
    m3Apply (up1, M2, up2);
    m3Apply (up2, M3, up1);

    // Rotate around the Z axis to put the UP
    // vector in the Y-Z plane.
    d3 = sqrt(up1[0] * up1[0] + up1[1] * up1[1]);
    m3Identity( M4);
    
    // If d3 = 0 then the UP vector is a zero
    // vector so do nothing.
    if (d3 !=0)
	{
        sin3 = up1[0] / d3;
        cos3 = up1[1] / d3;
        M4[0][0] = cos3;
        M4[0][1] = sin3;
        M4[1][0] = -sin3;
        M4[1][1] = cos3;
	}
    
    // Project.
    if ((ptype == m3Perspective) && (d2 !=0))
        m3PerspectiveXZ( M5, d2);
    else
        m3Identity (M5);
    

    // Combine the transformations.
    m3MatMultiply( M12, M1, M2);
    m3MatMultiply( M34, M3, M4);
    m3MatMultiply( M1234, M12, M34);
    if (ptype = m3Perspective)
        m3MatMultiplyFull (M, M1234, M5);
	else
        m3MatMultiply( M, M1234, M5);
    
}


// Create a transformation matrix for reflecting
// across the plane passing through (p1, p2, p3)
// with normal vector <n1, n2, n3>.
void m3Reflect(float M[4][4], float p1, float p2, float p3, float n1, float n2, float n3)
{
	float T[4][4];//     ' Translate.
	float R1[4][4];//    ' Rotate 1.
	float r2[4][4];//    ' Rotate 2.
	float S[4][4];//     ' Reflect.
	float R2i[4][4];//   ' Unrotate 2.
	float R1i[4][4];//   ' Unrotate 1.
	float Ti[4][4];//    ' Untranslate.
	float D;
	float L;
	float M12[4][4];
	float M34[4][4];
	float M1234[4][4];
	float M56[4][4];
	float M567[4][4];

    // Translate the plane to the origin.
    m3Translate(T, -p1, -p2, -p3);
    m3Translate(Ti, p1, p2, p3);

    // Rotate around Z-axis until the normal is in
    // the Y-Z plane.
    m3Identity (R1);
    D = sqrt(n1 * n1 + n2 * n2);
    R1[0][0] = n2 / D;
    R1[0][1] = n1 / D;
    R1[1][0] = -R1[0][1];
    R1[1][1] = R1[0][0];
    
    m3Identity( R1i);
    R1i[0][0] = R1[0][0];
    R1i[0][1] = -R1[0][1];
    R1i[1][0] = -R1[1][0];
    R1i[1][1] = R1[1][1];
    
    // Rotate around the X-axis until the normal
    // lies along the Y axis.
    m3Identity( r2);
    L = sqrt(n1 * n1 + n2 * n2 + n3 * n3);
    r2[1][1] = D / L;
	r2[1][2] = -n3 / L;
    r2[2][1] = -r2[1][2];
    r2[2][2] = r2[1][1];
    
    m3Identity( R2i);
    R2i[1][1] = r2[1][1];
    R2i[1][2] = -r2[1][2];
    R2i[2][1] = -r2[2][1];
    R2i[2][2] = r2[2][2];

    // Reflect across the X-Z plane.
    m3Identity( S);
    S[1][1] = -1;

    // Combine the matrices.
    m3MatMultiply( M12, T, R1);
    m3MatMultiply( M34, r2, S);
    m3MatMultiply( M1234, M12, M34);
    m3MatMultiply( M56, R2i, R1i);
    m3MatMultiply( M567, M56, Ti);
    m3MatMultiply( M, M1234, M567);
}

// Create a 3-D transformation matrix for scaling
// by scale factors Sx, Sy, and Sz.
void m3Scale(float M[4][4], float Sx, float Sy, float Sz)
{
	m3Identity( M);
	M[0][0] = Sx;
	M[1][1] = Sy;
	M[2][2] = Sz;
}

// Create a 3-D transformation matrix for
// translation by Tx, Ty, and Tz.
void m3Translate(float M[4][4], float Tx, float Ty, float Tz)
{
	m3Identity( M);
	M[3][0] = Tx;
	M[3][1] = Ty;
	M[3][2] = Tz;
}

// Create a 3-D transformation matrix for rotation
// around the X axis (angle measured in radians).
void m3XRotate(float M[4][4], float theta)
{
	m3Identity( M);
	M[1][1] = cos(theta);
	M[2][2] = M[1][1];
	M[1][2] = sin(theta);
	M[2][1] = -M[1][2];
}

// Create a 3-D transformation matrix for rotation
// around the Y axis (angle measured in radians).
void m3YRotate(float M[4][4], float theta)
{
    m3Identity( M);
    M[0][0] = cos(theta);
    M[2][2] = M[0][0];
    M[2][0] = sin(theta);
    M[0][2] = -M[2][0];
}

// Create a 3-D transformation matrix for rotation
// around the Z axis (angle measured in radians).
void m3ZRotate(float M[4][4], float theta)
{
    m3Identity( M);
    M[0][0] = cos(theta);
    M[1][1] = M[0][0];
    M[0][1] = sin(theta);
    M[1][0] = -M[0][1];
}

// Create a matrix that rotates around the Y axis
// so the point (x, y, z) lies in the X-Z plane.
void m3YRotateIntoXZ(float Result[4][4], float X, float Y, float Z)
{
float D=0;

    m3Identity( Result);
    D = sqrt(X * X + Y * Y);
    Result[0][0] = X / D;
    Result[0][1] = -Y / D;
    Result[1][0] = -Result[0][1];
    Result[1][1] = Result[0][0];
}

// Set copy = orig.
void m3MatCopy(float *copy[], float *orig[])
{
int i=0;
int j=0;

    for( i = 0; i < 4; i++)
        for( j = 0; j < 4; j++)
            copy[i][j] = orig[i][j];
}


// Create a transformation atrix for rotating
// through angle theta around a line passing
// through (p1, p2, p3) in direction <d1, d2, d3>.
// Theta is measured counterclockwise as you look
// down the line opposite the line's direction.
void m3LineRotate(float M[4][4], float p1, float p2, float p3, float d1, float d2, float d3, float theta)
{
	float T[4][4];//     ' Translate.
	float R1[4][4];//    ' Rotate 1.
	float r2[4][4];//    ' Rotate 2.
	float Rot3[4][4];//  ' Rotate.
	float R2i[4][4];//   ' Unrotate 2.
	float R1i[4][4];//   ' Unrotate 1.
	float Ti[4][4];//    ' Untranslate.
	float D;
	float L;
	float M12[4][4];
	float M34[4][4];
	float M1234[4][4];
	float M56[4][4];
	float M567[4][4];

    // Translate the plane to the origin.
    m3Translate( T, -p1, -p2, -p3);
    m3Translate( Ti, p1, p2, p3);

    // Rotate around Z-axis until the line is in
    // the Y-Z plane.
    m3Identity( R1);
    D = sqrt(d1 * d1 + d2 * d2);
    R1[0][0] = d2 / D;
    R1[0][1] = d1 / D;
    R1[1][0] = -R1[0][1];
    R1[1][1] = R1[0][0];
    
    m3Identity( R1i);
    R1i[0][0] = R1[0][0];
    R1i[0][1] = -R1[0][1];
    R1i[1][0] = -R1[1][0];
    R1i[1][1] = R1[1][1];
    
    // Rotate around the X-axis until the line
    // lies along the Y axis.
    m3Identity( r2);
    L = sqrt(d1 * d1 + d2 * d2 + d3 * d3);
    r2[1][1] = D / L;
    r2[1][2] = -d3 / L;
    r2[2][1] = -r2[1][2];
    r2[2][2] = r2[1][1];
    
    m3Identity( R2i);
    R2i[1][1] = r2[1][1];
    R2i[1][2] = -r2[1][2];
    R2i[2][1] = -r2[2][1];
    R2i[2][2] = r2[2][2];

    // Rotate around the line (Y axis).
    m3YRotate( Rot3, theta);

    // Combine the matrices.
    m3MatMultiply( M12, T, R1);
    m3MatMultiply( M34, r2, Rot3);
    m3MatMultiply( M1234, M12, M34);
    m3MatMultiply( M56, R2i, R1i);
    m3MatMultiply( M567, M56, Ti);
	m3MatMultiply( M, M1234, M567);
}



// Create a 3-D transformation matrix for a
// perspective projection with:
//       center of projection    (r, phi, theta)
//       focus                   (fx, fy, fx)
//       up vector               <ux, uy, uz>
// ptype should be m3Perspective or m3Parallel.
void m3PProject(float M[4][4], int ptype, float R, float phi, float theta, float Fx, float Fy, float Fz, float ux, float uy, float uz)
{
	float Cx=0;
	float Cy=0;
	float Cz=0;
	float r2=0;

    // Convert to Cartesian coordinates.
    Cy = R * sin(phi);
    r2 = R * cos(phi);
    Cx = r2 * cos(theta);
    Cz = r2 * sin(theta);
    m3Project( M, ptype, Cx, Cy, Cz, Fx, Fy, Fz, ux, uy, uz);
}

// Apply a transformation matrix to a point.
void m3Apply(float V[], float M[4][4], float Result[])
{
    Result[0] = V[0] * M[0][0] + 
                V[1] * M[1][0] + 
                V[2] * M[2][0] + M[3][0];
    Result[1] = V[0] * M[0][1] + 
                V[1] * M[1][1] + 
                V[2] * M[2][1] + M[3][1];
    Result[2] = V[0] * M[0][2] + 
                V[1] * M[1][2] + 
                V[2] * M[2][2] + M[3][2];
    Result[3] = 1.;
}

// Apply a transformation matrix to a point where
// the transformation may not have 0, 0, 0, 1 in
// its final column. Normalize only the X and Y
// components of the result to preserve the Z
// information.
void m3ApplyFull(float V[], float M[4][4], float Result[])
{
	int i=0;
	int j=0;
	float value=0;

    for( i = 0; i < 4; i++)
	{
        value = 0;
        for(j=0; j < 4; j++)
			value += V[j] * M[j][i];
        
        Result[i] = value;
	}
    
    // Renormalize the point.
    // Note that value still holds Result(4).
  
	if( value != 0)
	{
        Result[0] /= value;
        Result[1] /= value;
        // Do not transform the Z component.
	}
	else
	{
        // Make the Z value greater than that of
        // the center of projection so the point
        // will be clipped.
        Result[2] = MYINFINITY;
	}
    Result[3] = 1;
}



// Multiply two matrices together. The matrices
// may not contain 0, 0, 0, 1 in their last
// columns.
void m3MatMultiplyFull(float Result[4][4],float A[4][4], float B[4][4])
{
	int i=0;
	int j=0;
	int k=0;
	float value=0;

    for(i=0; i < 4; i++)
	{
		for (j =0; j < 4; j++)
		{
            value = 0.;
            for( k = 0; k < 4; k++)
                value +=  A[i][k] * B[k][j];
            
            Result[i][j] = value;
		}
	}
}
// Multiply two matrices together.
void m3MatMultiply(float Result[4][4],float A[4][4], float B[4][4])
{
    Result[0][0] = A[0][0] * B[0][0] + A[0][1] * B[1][0] + A[0][2] * B[2][0];
    Result[0][1] = A[0][0] * B[0][1] + A[0][1] * B[1][1] + A[0][2] * B[2][1];
    Result[0][2] = A[0][0] * B[0][2] + A[0][1] * B[1][2] + A[0][2] * B[2][2];
    Result[0][3] = 0.;
    Result[1][0] = A[1][0] * B[0][0] + A[1][1] * B[1][0] + A[1][2] * B[2][0];
    Result[1][1] = A[1][0] * B[0][1] + A[1][1] * B[1][1] + A[1][2] * B[2][1];
    Result[1][2] = A[1][0] * B[0][2] + A[1][1] * B[1][2] + A[1][2] * B[2][2];
    Result[1][3] = 0.;
    Result[2][0] = A[2][0] * B[0][0] + A[2][1] * B[1][0] + A[2][2] * B[2][0];
    Result[2][1] = A[2][0] * B[0][1] + A[2][1] * B[1][1] + A[2][2] * B[2][1];
    Result[2][2] = A[2][0] * B[0][2] + A[2][1] * B[1][2] + A[2][2] * B[2][2];
	Result[2][3] = 0.;
    Result[3][0] = A[3][0] * B[0][0] + A[3][1] * B[1][0] + A[3][2] * B[2][0] + B[3][0];
    Result[3][1] = A[3][0] * B[0][1] + A[3][1] * B[1][1] + A[3][2] * B[2][1] + B[3][1];
    Result[3][2] = A[3][0] * B[0][2] + A[3][1] * B[1][2] + A[3][2] * B[2][2] + B[3][2];
    Result[3][3] = 1.;
}

// Compute the cross product of two vectors.
// Set <X, Y, Z> = <x1, y1, z1> X <x2, y2, z2>.
void m3Cross(float &X, float &Y, float &Z, float x1, float y1, float z1, float x2, float y2, float z2)
{
	X = y1 * z2 - z1 * y2;
    Y = z1 * x2 - x1 * z2;
    Z = x1 * y2 - y1 * x2;
}

// Give the vector the indicated length.
void m3SizeVector(float L, float &X, float &Y, float &Z)
{
	L = L / sqrt(X * X + Y * Y + Z * Z);
    X = X * L;
    Y = Y * L;
    Z = Z * L;
}
