#include "stdafx.h"
#include "ValleyGrid3d.h"

#include <iostream>
#include <cmath>
using namespace std;

//' Create the Points array.
void ValleyGrid3d::SetBounds(float x1, float deltax, int xnum, float z1, float deltaz, int znum)
{
	int i=0;
	int j=0;
	float X=0;
	float Z=0;

    Xmin = x1;
    Zmin = z1;
    Dx = deltax;
    Dz = deltaz;
    NumX = xnum;
    NumZ = znum;

	points = new Point3D*[NumX];
	for( i = 0; i < NumX; ++i) {
		points[i] = new Point3D[NumZ];
	}
    
    X = Xmin;
    for( i = 0; i < NumX; i++)
	{
        Z = Zmin;
        for( j = 0; j <  NumZ; j++)
		{
            points[i][j].coord[0] = X;
            points[i][j].coord[1] = 0;
            points[i][j].coord[2] = Z;
            points[i][j].coord[3] = 1.;
            Z += Dz;
		}
        X += Dx;
	}
}

// Generate the fractal surface.
void ValleyGrid3d::GenerateSurface(int divisions,float Dy)
{
Point3D **oldpoints=NULL;
int oldx=0;
int oldz=0;
int factor=0;
int newx=0;
int newz=0;
int i=0;
int j=0;
int newi=0;
int newj=0;

    // Make room for the new data.
    factor = pow(2., divisions);
    newx = (NumX - 1) * factor + 1;
    newz = (NumZ - 1) * factor + 1;

    // Copy the original data.
	oldpoints = new Point3D*[NumZ];
	for( i = 0; i < NumZ; ++i) {
		oldpoints[i] = new Point3D[NumX];
	}

	for( i = 0; i < NumX; i++)
	 for( j = 0; j < NumZ; j++)
		oldpoints[i][j] = points[i][j];
   
    // Resize and initialize the Points array.
    oldx = NumX;
    oldz = NumZ;
    SetBounds( Xmin, Dx / factor, newx, Zmin, Dz / factor, newz);

    // Move the old data to the new positions.
    newi = 0;
    for( i = 0; i < oldx; i++)
	{
        newj = 0;
        for( j = 0; j <  oldz; j++)
		{
			points[newi][newj] = oldpoints[i][j];
            newj += factor;
		}
        newi += factor;
	}

    // Subdivide each area in the data.
    newi = 0;
    for( i = 1; i < oldx; i++)
	{
        newj = 0;
        for( j = 1; j < oldz; j++)
		{
            Subdivide (newi, newi + factor, 
                      newj, newj + factor, Dy);
            newj += factor;
		}
        newi += factor;
	}
}

//' If a Y value is within distance range of the
//' value target_y, then reduce that distance by
//' a factor of smooth_factor.
void ValleyGrid3d::Flatten(float target_y, float range, float smooth_factor)
{
int i=0;
int j=0;
float diff=0;

    for( i = 0;i < NumX; i++)
	{
        for (j = 0; j < NumZ; j++)
		{
			diff = points[i][j].coord[1] - target_y;
            if (abs(diff) < range)
				points[i][j].coord[1] = target_y + smooth_factor * diff;
 		}
	}
}

HBRUSH ValleyGrid3d::FillColor(HDC hdc,string sItem, COLORREF *cr )
{
	
	HBRUSH	hBrush=(HBRUSH)GetStockObject(WHITE_BRUSH);

	if(cr != NULL)
	{
		hBrush = CreateSolidBrush(*cr);
	}else
	{
	 if (sItem.compare("river")==0)
		hBrush = CreateSolidBrush(RGB(0, 0x80, 0xFF));
	 
	 else if (sItem.compare("snow")==0)
		hBrush = CreateSolidBrush(RGB(0xCC, 0xFF, 0xFF));
	 
	 else if (sItem.compare("vegetation")==0)
	 	hBrush = CreateSolidBrush(RGB(0x00, 0x80, 0x00));
	 
	 else if (sItem.compare("cliff")==0)
		hBrush = CreateSolidBrush(RGB(0xC0, 0xC0, 0xC0));
	 
	}

return hBrush;
}
// Pick a color for this area.
HBRUSH ValleyGrid3d::PickColor(HDC hdc, float y1, float y2, float y3, float y4)
{
	HBRUSH hBrush=NULL;
float min_y=0;
float max_y=0;
int g=0;
int b=0;

    min_y = y1;
    max_y = y1;
    if (min_y > y2) 
		min_y = y2;
    if (max_y < y2)
		max_y = y2;
    if (min_y > y3)
		min_y = y3;
    if (max_y < y3)
		max_y = y3;
    if (min_y > y4)
		min_y = y4;
    if (max_y < y4)
		max_y = y4;

    if (max_y < -1.09)	//' River.
        hBrush = FillColor(hdc,"river");
    else if (max_y > 0.7) //' Snow.
        hBrush = FillColor(hdc,"snow");
    else if (abs(min_y - max_y) < 0.3) // Vegetation.
	{
		int r=0;
		g = 0xFF - (min_y + 1) * 70;
        b = 0x80 - (min_y + 1) * 100;
		g=(g >0xFF)? 0xFF:g;
		b=(b >0xFF)? 0xFF:b;
		g=(g <0)? 0:g;
		b=(b <0)? 0:b;

		COLORREF cr = RGB(r, g, b);
        hBrush = FillColor(hdc,"Vegetation",&cr);
 	}
	else        // Cliff.
        hBrush = FillColor(hdc,"cliff");
    
	return hBrush;
}

//' Recursively subdivide the indicated area.
void ValleyGrid3d::Subdivide(int i1, int i2, int j1, int j2, float Dy)
{
float y11=0;
float y12=0;
float y21=0;
float y22=0;
int imid=0;
int jmid=0;

    if ((i2 - i1 <= 1) || (j2 - j1 <= 1))
		return;

    // Compute the midpoint locations.
    y11 = points[i1][j1].coord[1];
    y12 = points[i1][j2].coord[1];
    y21 = points[i2][j1].coord[1];
    y22 = points[i2][j2].coord[1];

    imid = (i1 + i2) / 2;
    jmid = (j1 + j2) / 2;
    points[i1][jmid].coord[1] = (y11 + y12) / 2 + 2 * Dy * myrand() - Dy;
    points[i2][jmid].coord[1] = (y21 + y22) / 2 + 2 * Dy * myrand() - Dy;
    points[imid][j1].coord[1] = (y11 + y21) / 2 + 2 * Dy * myrand() - Dy;
    points[imid][j2].coord[1] = (y12 + y22) / 2 + 2 * Dy * myrand() - Dy;
	points[imid][jmid].coord[1] = (y11 + y12 + y21 + y22) / 4 + 2 * Dy * myrand() - Dy;

    // Recursively subdivide the four new areas.
    Subdivide( i1, imid, j1, jmid, Dy / 2);
    Subdivide( imid, i2, j1, jmid, Dy / 2);
    Subdivide( i1, imid, jmid, j2, Dy / 2);
    Subdivide( imid, i2, jmid, j2, Dy / 2);
}

// Save the indicated data value.
void ValleyGrid3d::SetValue(float X, float Y, float Z)
{
int i=0;
int j=0;

    i = (X - Xmin) / Dx + 1;
    j = (Z - Zmin) / Dz + 1;
    points [i-1][j-1].coord[1] = Y;
}

//
// Apply a transformation matrix which may not
// contain 0, 0, 0, 1 in the last column to the
// object.
void ValleyGrid3d::ApplyFull(float M[4][4])
{
int i=0;
int j=0;

    for( i = 0; i < NumX; i++)
        for( j = 0; j < NumZ; j++)
            m3ApplyFull (points[i][j].coord, M, points[i][j].trans);
}

// Apply a transformation matrix to the object.
void ValleyGrid3d::Apply(float M[4][4])
{
int i=0;
int j=0;

    for( i = 0; i < NumX; i++)
        for( j = 0; j < NumZ; j++)
			m3Apply (points[i][j].coord, M, points[i][j].trans);
}

// Draw the transformed points on a PictureBox.
void ValleyGrid3d::Draw(HDC hdc)
{
	int i=0;
	int j=0;
	POINT api_points[4];


    // Draw the "rectangles."
    for( i = 0;i < NumX - 1;i++)
	{
        for (j = 0;j< NumZ - 1; j++)
		{
         //Load the POINTAPI array.
                api_points[0].x = points[i][j].trans[0];
                api_points[0].y = points[i][j].trans[1];
                
				api_points[1].x = points[i + 1][j].trans[0];
                api_points[1].y = points[i + 1][j].trans[1];
                
				api_points[2].x = points[i + 1][j + 1].trans[0];
                api_points[2].y = points[i + 1][j + 1].trans[1];
            

                api_points[3].x = points[i][j + 1].trans[0];
                api_points[3].y = points[i][j + 1].trans[1];
         
				HBRUSH hBrush;
				HBRUSH hBrushOri;
            hBrush = PickColor (hdc, 
                points[i][j].coord[1], 
                points[i + 1][j].coord[1], 
                points[i + 1][j + 1].coord[1], 
                points[i][j + 1].coord[1]);

			hBrushOri = (HBRUSH)SelectObject(hdc, hBrush);
            Polygon(hdc, (const POINT *)&(api_points[0]), 4);
			SelectObject(hdc,hBrushOri);
			DeleteObject(hBrush);
		}
	}
}
//};
