# -*- coding:utf-8 -*-
###NAO_RedBall.py - Programma per il Riconoscimento della Palla Rossa

import cv2
import numpy as np

img = cv2.imread('RedBall.png')
RED_MIN = np.array([0, 100, 100],np.uint8)
RED_MAX = np.array([60, 255, 255],np.uint8)

hsv_img = cv2.cvtColor(img,cv2.COLOR_BGR2HSV)
frame_threshed = cv2.inRange(hsv_img, RED_MIN, RED_MAX)
cv2.imshow('ori 0',img)

cv2.imshow('HSVresult 1',frame_threshed)

blur = cv2.GaussianBlur(frame_threshed,(5,5),0)
cv2.imshow('Gaussian Blur 2',blur)

kernel = np.ones((5,5),np.uint8)
dilation = cv2.dilate(blur,kernel,iterations = 3)
blur = cv2.erode(dilation,kernel,iterations = 3)
cv2.imshow('dilat 3',blur)
edges = cv2.Canny(blur,50,300)
cv2.imshow('canny 4',edges)

circles=cv2.HoughCircles(edges,cv2.cv.CV_HOUGH_GRADIENT,1,25,param1=55,param2=25,minRadius=10,maxRadius=0)
circles = np.uint16(np.around(circles))
for i in circles[0,:]:
    center=(i[0],i[1])
    radius = i[2]
    # draw the outer circle
    cv2.circle( img, center, radius, (0,255,0),2)
    # draw the center of the circle
    cv2.circle( img, center, 2, (0,0,255),3)
    print "center",center,"    radius=",radius

cv2.imshow('detected circles 5',img)
cv2.waitKey(0)
cv2.destroyAllWindows()

