###FILT2D.PY - Estrazione di contorni da un file immagine.

from PIL import Image,ImageOps
import numpy as np

import matplotlib.pyplot as plt
import matplotlib.image as mpimg

def MatrixSize(M):
    return len(M),len(M[0])

def MatrixCreate(NR,NC,val=0):
    return [[val for col in range(NC)] for row in range(NR)]

def MatrixConvolve(M,K,factor=1.0,bias=0.0):
    w,h=MatrixSize(M)
    filterWidth,filterHeight=MatrixSize(K)
    result = np.copy(M)
    for x in range(w): 
        for y in range(h): 
            red = 0.0
            green = 0.0
            blue = 0.0 
         
            for filterX in range(filterWidth): 
                for filterY in range(filterHeight): 
                    imageX = (x - filterWidth / 2 + filterX + w) % w 
                    imageY = (y - filterHeight / 2 + filterY + h) % h
                    color = M[imageX][imageY]
                    red += color[0] * K[filterX][filterY] 
                    green += color[1] * K[filterX][filterY] 
                    blue += color[2] * K[filterX][filterY] 
         
            r = min(max(int(factor * red + bias), 0), 255) 
            g = min(max(int(factor * green + bias), 0), 255) 
            b = min(max(int(factor * blue + bias), 0), 255)
            result[x,y] = r,g,b
    return result


def MatrixInvertColor(M):
    w,h=MatrixSize(M)
    result = np.copy(M)
    for x in range(w): 
        for y in range(h): 
            red = 0.0
            green = 0.0
            blue = 0.0
            color = M[x][y]
            r=255-color[0] 
            g=255-color[1]
            b=255-color[2]        
            result[x,y] = r,g,b
    return result

def LoadImg(sFile):
    im = Image.open(sFile)
    return np.array(im)
    pass

def MatrixToImg(M):
    return Image.fromarray(M)

def Draw(img,n,sTitle=None):
    plt.subplot(n+120)
    if sTitle != None:
        plt.title(sTitle)
    imgplot = plt.imshow(img)
    return imgplot

def Show():
    plt.show()

def main():
    kernel =[
    [-1, -1, -1],
    [-1,  8, -1],
    [-1, -1, -1]
]
    img = LoadImg("Image1.jpg")
    cv = MatrixConvolve(img,kernel)
    cvi=MatrixToImg(cv)
    Draw(img,1,"Ori")
    Draw(cvi,2,"Result")
    Show()

if __name__ == "__main__":
    try:
        main()
    except Exception as e:
        print e.__doc__
        print e.message
