###CONV2D.PY  CONVOLUZIONE 2D

def MatrixCreate(NR,NC,val=0):
    return [[val for col in range(NC)] for row in range(NR)]
def MatrixIsEmpty(M):
    if(M==None):
        return True
    return len(M)==1 and len(M[0])==0
def MatrixSize(M):
    if(MatrixIsEmpty(M)):
        return 0,0
    return len(M),len(M[0])
def printMatrix(M):
    print '\n'.join([str(i) for i in M])

def MatrixConvolve2D(M,kernel):
    rows,cols=MatrixSize(M)
    kRows,kCols=MatrixSize(kernel)
    out = MatrixCreate(rows,cols) 
    
    kCenterX = kCols / 2;
    kCenterY = kRows / 2;

    for i in range(rows):
        for j in range(cols):
            z = MatrixCreate(rows,cols) 
            v=M[i][j]
            z[i][j] = v
            for ik in  range(kRows):
                for jk in  range(kCols):
                    m = ik-kCenterX+i
                    n = jk-kCenterY+j
                    if not(m<0 or n<0 or m>=kRows or n>=kCols):
                        z[m][n] = v*kernel[ik][jk]

            for a in range(rows):
                for b in range(cols):
                    out[a][b] += z[a][b]
    return out
inp=[
        [1,2,3],
        [4,5,6],
        [7,8,9]
        ]
kernel =[
        [-1, -2, -1],
        [0,  0, 0],
        [1, 2, 1]
    ]
out = MatrixConvolve2D(inp,kernel)
printMatrix( out)
